/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.BM;
import com.blixx.shared.IID;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.TreeObject;
import com.blixx.shared.utils.XMLTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.w3c.dom.Document;

public class GroupTreeObject
implements Cloneable,
Comparable<GroupTreeObject>,
IID {
    public static final String GROUPS = "_Groups";
    private static final String REGEX_GTO_PATH = "\\Q" + BM.GTO_PATH_SEPARATOR + "\\E";
    protected GroupTreeObject parent = null;
    protected String m_lastTreePath = null;
    protected List<GroupTreeObject> elements = null;
    protected Map<String, GroupTreeObject> m_map = null;
    protected ITreeObject m_obj = null;
    protected Map<String, String> m_attributes = null;
    protected String m_icon = null;
    public static final String GTOLABEL = "GTOLABEL";
    public static final String GTOICON = "GTOICON";
    private static ConcurrentMap<String, String> map = new ConcurrentHashMap<String, String>(1000);

    public GroupTreeObject(String name, String type) {
        this(new TreeObject(name, type, null));
    }

    public GroupTreeObject(String name, String type, Object obj) {
        this(new TreeObject(name, type, obj));
    }

    public GroupTreeObject(ITreeObject treeObject) {
        this.m_obj = treeObject;
        this.elements = Collections.synchronizedList(new ArrayList(0));
        this.m_map = new ConcurrentHashMap<String, GroupTreeObject>(5, 0.9f, 3);
    }

    public void ensureCapacity(int num) {
        if (this.elements instanceof ArrayList) {
            ((ArrayList)this.elements).ensureCapacity(num);
        }
    }

    public ITreeObject getTreeObject() {
        return this.m_obj;
    }

    public void setTreeObject(ITreeObject to) {
        GroupTreeObject gtoParent = this.getParent();
        String nameType = this.getNameType();
        this.m_obj = to;
        if (gtoParent != null) {
            gtoParent.m_map.remove(nameType);
            gtoParent.m_map.put(this.getNameType(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        if (this.elements != null) {
            List<GroupTreeObject> list = this.elements;
            synchronized (list) {
                for (GroupTreeObject next : this.elements) {
                    next.m_lastTreePath = this.getPath();
                    next.clean();
                }
                this.elements.clear();
            }
            this.m_map.clear();
        }
    }

    public String getParentPath() {
        if (this.parent != null) {
            return this.parent.getPath();
        }
        if (this.m_lastTreePath != null) {
            return this.m_lastTreePath;
        }
        return "";
    }

    public String getName() {
        if (this.m_obj == null) {
            return "";
        }
        return this.m_obj.getName();
    }

    public void setName(String name) {
        if (this.m_obj != null && !name.equals(this.m_obj.getName())) {
            GroupTreeObject gtoParent = this.getParent();
            String nameType = this.getNameType();
            if (gtoParent != null && gtoParent.getChild(name, this.getType()) != null) {
                throw new RuntimeException("Can't rename elements. Already exist");
            }
            this.m_obj.setName(name);
            if (gtoParent != null) {
                gtoParent.m_map.remove(nameType);
                gtoParent.m_map.put(this.getNameType(), this);
            }
        }
    }

    public void setType(String type) {
        type = type == null ? "" : type.intern();
        if (this.m_obj != null && !type.equals(this.m_obj.getType())) {
            GroupTreeObject gtoParent = this.getParent();
            GroupTreeObject potentialConflict = null;
            if (gtoParent != null) {
                potentialConflict = gtoParent.getChild(this.getName(), type);
            }
            if (gtoParent != null && potentialConflict != null) {
                boolean f2;
                boolean f1 = "".equals(type) || "toplevel".equals(type);
                String type2 = potentialConflict.getType();
                boolean bl = f2 = "".equals(type2) || "toplevel".equals(potentialConflict.getType());
                if (!f1 && !f2) {
                    throw new RuntimeException("Can't rename elements. Already exist");
                }
            }
            String nameType = this.getNameType();
            this.m_obj.setType(type);
            if (gtoParent != null) {
                gtoParent.m_map.remove(nameType);
                gtoParent.m_map.put(this.getNameType(), this);
            }
        }
    }

    public String getIcon() {
        return this.m_icon;
    }

    public void setIcon(String icon) {
        this.m_icon = icon.intern();
    }

    public void addElement(GroupTreeObject obj) {
        if (obj == null) {
            return;
        }
        GroupTreeObject child = this.getChild(obj.getName(), obj.getType());
        if (child != null) {
            throw new RuntimeException("Tree element does already exist:" + obj.getName() + " ParentTreePath:" + this.getPath());
        }
        this.elements.add(obj);
        this.m_map.put(obj.getNameType(), obj);
        this.sortElements();
        obj.parent = this;
    }

    public void addElementNoSorting(GroupTreeObject obj) {
        if (obj == null) {
            return;
        }
        GroupTreeObject child = this.getChild(obj.getName(), obj.getType());
        if (child != null && child.getNameType().equals(obj.getNameType())) {
            throw new RuntimeException("Tree element does already exist:" + obj.getName() + " ParentTreePath:" + this.getPath());
        }
        this.elements.add(obj);
        this.m_map.put(obj.getNameType(), obj);
        obj.parent = this;
    }

    public void addElementNoSortingNoChecking(GroupTreeObject obj) {
        if (obj == null) {
            return;
        }
        this.elements.add(obj);
        this.m_map.put(obj.getNameType(), obj);
        obj.parent = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortElements() {
        List<GroupTreeObject> list = this.elements;
        synchronized (list) {
            Collections.sort(this.elements, new Comparator<GroupTreeObject>(this){

                @Override
                public int compare(GroupTreeObject a, GroupTreeObject b) {
                    return a.getLabelForSorting().compareToIgnoreCase(b.getLabelForSorting());
                }
            });
        }
    }

    public void sortElementsRecursive() {
        this.sortElements();
        for (int i = 0; i < this.elements.size(); ++i) {
            GroupTreeObject gto = this.elements.get(i);
            if (!gto.hasElements().booleanValue()) continue;
            gto.sortElementsRecursive();
        }
    }

    public void addElements(List<GroupTreeObject> al) {
        this.ensureCapacity(this.elements.size() + al.size());
        Iterator<GroupTreeObject> it = al.iterator();
        while (it.hasNext()) {
            this.addElementNoSorting(it.next());
        }
        this.sortElements();
    }

    public void removeElement(GroupTreeObject obj) {
        if (obj == null) {
            return;
        }
        obj.m_lastTreePath = this.getPath();
        this.elements.remove(obj);
        this.m_map.remove(obj.getNameType());
    }

    public List<GroupTreeObject> getElements() {
        return this.elements;
    }

    public List<GroupTreeObject> getAllElements() {
        ArrayList<GroupTreeObject> all = new ArrayList<GroupTreeObject>(this.elements.size());
        for (int i = 0; i < this.elements.size(); ++i) {
            GroupTreeObject go = this.elements.get(i);
            if (!go.isGroup()) {
                all.add(go);
                continue;
            }
            all.add(go);
            List<GroupTreeObject> subs = go.getAllElements();
            all.ensureCapacity(all.size() + subs.size());
            all.addAll(subs);
        }
        return all;
    }

    public List<GroupTreeObject> getAllGroups() {
        ArrayList<GroupTreeObject> all = new ArrayList<GroupTreeObject>(this.elements.size());
        for (int i = 0; i < this.elements.size(); ++i) {
            GroupTreeObject go = this.elements.get(i);
            if (!go.isGroup()) continue;
            all.add(go);
            List<GroupTreeObject> subs = go.getAllGroups();
            all.ensureCapacity(all.size() + subs.size());
            all.addAll(subs);
        }
        return all;
    }

    public List<GroupTreeObjectLast> getAllGTOLs() {
        ArrayList<GroupTreeObjectLast> all = new ArrayList<GroupTreeObjectLast>(this.elements.size());
        for (int i = 0; i < this.elements.size(); ++i) {
            GroupTreeObject go = this.elements.get(i);
            if (!go.isGroup() && !go.isUnsubmitted()) {
                all.add((GroupTreeObjectLast)go);
                continue;
            }
            List<GroupTreeObjectLast> subs = go.getAllGTOLs();
            all.ensureCapacity(all.size() + subs.size());
            all.addAll(subs);
        }
        return all;
    }

    public List<GroupTreeObject> getAllElements(int capacity) {
        ArrayList<GroupTreeObject> all = new ArrayList<GroupTreeObject>(capacity);
        for (int i = 0; i < this.elements.size(); ++i) {
            GroupTreeObject go = this.elements.get(i);
            if (!go.isGroup() && !go.isUnsubmitted()) {
                all.add(go);
                continue;
            }
            all.add(go);
            List<GroupTreeObject> subs = go.getAllElements();
            all.ensureCapacity(all.size() + subs.size());
            all.addAll(subs);
        }
        return all;
    }

    public Map<GroupTreeObject, GroupTreeObject> getAllElementsMap() {
        HashMap<GroupTreeObject, GroupTreeObject> all = new HashMap<GroupTreeObject, GroupTreeObject>();
        for (int i = 0; i < this.elements.size(); ++i) {
            GroupTreeObject go = this.elements.get(i);
            if (!go.isGroup() && !go.isUnsubmitted()) {
                all.put(go, go);
                continue;
            }
            all.put(go, go);
            Map<GroupTreeObject, GroupTreeObject> subs = go.getAllElementsMap();
            all.putAll(subs);
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupTreeObject getFirstChild(String name) {
        GroupTreeObject res = null;
        List<GroupTreeObject> list = this.elements;
        synchronized (list) {
            for (GroupTreeObject gto : this.elements) {
                if (gto.getName() == null || !gto.getName().equals(name)) continue;
                res = gto;
                break;
            }
        }
        return res;
    }

    public GroupTreeObject getChild(String name, String type) {
        GroupTreeObject res = null;
        String nt = GroupTreeObject.getNameType(name, type);
        res = this.m_map.get(nt);
        if (res == null && "".equals(type)) {
            res = this.m_map.get(GroupTreeObject.getNameType(name, "toplevel"));
        }
        return res;
    }

    public GroupTreeObject findFirstParent(String type) {
        GroupTreeObject res = null;
        if (this.getType().equals(type)) {
            res = this;
        } else {
            GroupTreeObject parent = this.getParent();
            if (parent != null) {
                res = parent.findFirstParent(type);
            }
        }
        return res;
    }

    public Boolean hasElements() {
        return this.elements.size() > 0;
    }

    public int hashCode() {
        return this.getNameType().hashCode();
    }

    public int numberOfElements() {
        return this.elements.size();
    }

    public GroupTreeObject getParent() {
        return this.parent;
    }

    public String toString() {
        return this.getName();
    }

    public String getNameType() {
        return GroupTreeObject.getNameType(this.getName(), this.getType());
    }

    public static String getNameType(String name, String type) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append('_').append(type);
        return GroupTreeObject.getCanonicalVersion(sb.toString());
    }

    public String getType() {
        String type = "";
        if (this.m_obj != null && this.m_obj.getType() != null) {
            type = this.m_obj.getType();
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupTreeObject findFirstGroupByName(String name) {
        GroupTreeObject res = null;
        List<GroupTreeObject> list = this.elements;
        synchronized (list) {
            for (GroupTreeObject gto : this.elements) {
                if (!gto.isGroup()) continue;
                if (name.equals(gto.getName())) {
                    res = gto;
                    break;
                }
                GroupTreeObject gtoRecursive = gto.findFirstGroupByName(name);
                if (gtoRecursive == null) continue;
                res = gtoRecursive;
                break;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupTreeObject findSubGroupByName(String name) {
        GroupTreeObject res = null;
        List<GroupTreeObject> list = this.elements;
        synchronized (list) {
            for (GroupTreeObject gto : this.elements) {
                if (!gto.isGroup() || !name.equals(gto.getName())) continue;
                res = gto;
                break;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupTreeObjectLast> findLinksByName(String linkedPath) {
        LinkedList<GroupTreeObjectLast> al = new LinkedList<GroupTreeObjectLast>();
        if (this.isGroup()) {
            List<GroupTreeObject> list = this.elements;
            synchronized (list) {
                for (GroupTreeObject o : this.elements) {
                    al.addAll(o.findLinksByName(linkedPath));
                }
            }
        } else {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)this;
            if (gtol.isItLink() && linkedPath.equals(gtol.getLinkedPath())) {
                al.add(gtol);
            }
        }
        return al;
    }

    public GroupTreeObject findByOID(String oid) {
        if (oid == null || oid.length() == 0) {
            return null;
        }
        for (GroupTreeObject groupTreeObject : this.getAllElements()) {
            if (groupTreeObject.getTreeObject() == null || groupTreeObject.getTreeObject().getOID() == null || !oid.equals(groupTreeObject.getTreeObject().getOID())) continue;
            return groupTreeObject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupTreeObjectLast> findLinksByName(String name, String type) {
        LinkedList<GroupTreeObjectLast> al = new LinkedList<GroupTreeObjectLast>();
        if (this.isGroup()) {
            List<GroupTreeObject> list = this.elements;
            synchronized (list) {
                for (GroupTreeObject o : this.elements) {
                    al.addAll(o.findLinksByName(name, type));
                }
            }
        } else {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)this;
            if (gtol.isItLink() && name.equals(gtol.getName()) && type.equals(gtol.getType())) {
                al.add(gtol);
            }
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupTreeObject> findLinksStartedWith(String linkedPath) {
        LinkedList<GroupTreeObject> al = new LinkedList<GroupTreeObject>();
        if (this.isGroup()) {
            List<GroupTreeObject> list = this.elements;
            synchronized (list) {
                for (GroupTreeObject o : this.elements) {
                    al.addAll(o.findLinksStartedWith(linkedPath));
                }
            }
        } else {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)this;
            if (gtol.isItLink() && gtol.getLinkedPath().startsWith(linkedPath)) {
                al.add(gtol);
            }
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupTreeObjectLast findElement(String name, String type) {
        GroupTreeObjectLast res = null;
        GroupTreeObject gto = this.getChild(name, type);
        if (gto != null && !gto.isGroup()) {
            res = (GroupTreeObjectLast)gto;
            return res;
        }
        List<GroupTreeObject> list = this.elements;
        synchronized (list) {
            for (GroupTreeObject o : this.elements) {
                if (o == null || !o.isGroup() || (res = o.findElement(name, type)) == null) continue;
                return res;
            }
        }
        return res;
    }

    public List<GroupTreeObject> findElements(String name, String type) {
        HashSet<String> types = new HashSet<String>(1);
        types.add(type);
        return this.findElements(name, types, null);
    }

    public List<GroupTreeObject> findElements(String name, String ... type) {
        HashSet<String> types = new HashSet<String>(type.length);
        for (String t : type) {
            types.add(t);
        }
        return this.findElements(name, types, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupTreeObject> findElementsByType(String type) {
        LinkedList<GroupTreeObject> list = new LinkedList<GroupTreeObject>();
        List<GroupTreeObject> list2 = this.elements;
        synchronized (list2) {
            for (GroupTreeObject gto : this.elements) {
                if (type.equals(gto.getType())) {
                    list.add(gto);
                } else if ("".equals(type) && "toplevel".equals(gto.getType())) {
                    list.add(gto);
                }
                if (!gto.hasElements().booleanValue()) continue;
                list.addAll(gto.findElementsByType(type));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GroupTreeObject> findElements(String name, Set<String> type, List<GroupTreeObject> list) {
        if (list == null) {
            list = new LinkedList<GroupTreeObject>();
        }
        boolean isFolder = type.contains("");
        List<GroupTreeObject> list2 = this.elements;
        synchronized (list2) {
            for (GroupTreeObject gto : this.elements) {
                if (name.equals(gto.getName())) {
                    if (type.contains(gto.getType())) {
                        list.add(gto);
                    } else if (isFolder && "toplevel".equals(gto.getType())) {
                        list.add(gto);
                    }
                }
                if (!gto.hasElements().booleanValue()) continue;
                gto.findElements(name, type, list);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupTreeObject> findAll(String name, String type) {
        LinkedList<GroupTreeObject> list = new LinkedList<GroupTreeObject>();
        List<GroupTreeObject> list2 = this.elements;
        synchronized (list2) {
            for (GroupTreeObject gto : this.elements) {
                if (gto.getName().equals(name) && gto.getType().equals(type)) {
                    list.add(gto);
                }
                if (!gto.hasElements().booleanValue()) continue;
                list.addAll(gto.findAll(name, type));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupTreeObject> findAllGTOL(String name, String type) {
        LinkedList<GroupTreeObject> list = new LinkedList<GroupTreeObject>();
        List<GroupTreeObject> list2 = this.elements;
        synchronized (list2) {
            for (GroupTreeObject gto : this.elements) {
                if (!gto.isGroup() && gto.getName().equals(name) && gto.getType().equals(type)) {
                    list.add(gto);
                    continue;
                }
                if (!gto.hasElements().booleanValue()) continue;
                list.addAll(gto.findAllGTOL(name, type));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameElements(String oldName, String newName, String type) {
        if (this.isGroup()) {
            List<GroupTreeObject> list = this.elements;
            synchronized (list) {
                for (GroupTreeObject o : this.elements) {
                    o.renameElements(oldName, newName, type);
                }
            }
        } else {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)this;
            if (type.equals(gtol.getTreeObject().getType()) && oldName.equals(gtol.getName())) {
                String linkedPath = gtol.getLinkedPath();
                if (linkedPath != null && linkedPath.endsWith("/" + oldName)) {
                    gtol.setLinkedPath(linkedPath.substring(0, linkedPath.lastIndexOf(47) + 1) + newName);
                }
                this.m_map.remove(gtol.getNameType());
                gtol.setName(newName);
                this.m_map.put(gtol.getNameType(), gtol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupTreeObject findFirstGroup(String name, String type) {
        GroupTreeObject res = null;
        if (!this.isGroup()) {
            return res;
        }
        if (type.equals(this.getType()) && name.equals(this.getName())) {
            res = this;
            return res;
        }
        if ("".equals(type) && "toplevel".equals(this.getType()) && name.equals(this.getName())) {
            res = this;
            return res;
        }
        List<GroupTreeObject> list = this.elements;
        synchronized (list) {
            for (GroupTreeObject o : this.elements) {
                res = o.findFirstGroup(name, type);
                if (res == null) continue;
                return res;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupTreeObject> findGroups(String name, String type) {
        LinkedList<GroupTreeObject> resultList = new LinkedList<GroupTreeObject>();
        List<GroupTreeObject> list = this.elements;
        synchronized (list) {
            for (GroupTreeObject o : this.elements) {
                if (!o.isGroup()) continue;
                if ((type == null || type.equals(o.getType()) || "".equals(type) && "toplevel".equals(o.getType())) && (name == null || name.equals(o.getName()))) {
                    resultList.add(o);
                }
                resultList.addAll(o.findGroups(name, type));
            }
        }
        return resultList;
    }

    public String getPath() {
        StringBuilder path = new StringBuilder();
        GroupTreeObject gto = this.getParent();
        if (gto != null) {
            path.append(gto.getPath());
        }
        path.append(BM.GTO_PATH_SEPARATOR).append(this.getName());
        return path.toString();
    }

    @Deprecated
    public GroupTreeObject searchPath(String treePath) {
        GroupTreeObject res = null;
        if (treePath.startsWith(this.getPath())) {
            if (treePath.equals(this.getPath())) {
                res = this;
            } else if (this.hasElements().booleanValue()) {
                List<GroupTreeObject> al = this.elements;
                for (int i = 0; i < al.size(); ++i) {
                    GroupTreeObject el = al.get(i);
                    GroupTreeObject obj = el.searchPath(treePath);
                    if (obj == null) continue;
                    res = obj;
                    break;
                }
            }
        }
        return res;
    }

    public GroupTreeObject searchPath(String treePath, String type) {
        GroupTreeObject res = null;
        String path = this.getPath();
        if (treePath.startsWith(path)) {
            if (treePath.equals(path) && (type.equals(this.getType()) || type.equals("") && "toplevel".equals(this.getType()))) {
                res = this;
            } else if (this.hasElements().booleanValue()) {
                List<GroupTreeObject> al = this.elements;
                for (int i = 0; i < al.size(); ++i) {
                    GroupTreeObject el = al.get(i);
                    GroupTreeObject obj = el.searchPath(treePath, type);
                    if (obj == null) continue;
                    res = obj;
                    break;
                }
            }
        }
        return res;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof GroupTreeObject)) {
            return false;
        }
        GroupTreeObject toCheck = (GroupTreeObject)arg0;
        if (!this.getType().equals(toCheck.getType())) {
            return false;
        }
        return this.getPath().equals(toCheck.getPath());
    }

    public boolean isEqualRecursive(GroupTreeObject gto) {
        String attr2;
        String attr1;
        if (this.getNameType().equals(gto.getNameType()) && (this.getTreeObject() == null ? gto.getTreeObject() == null : this.getTreeObject().equals(gto.getTreeObject())) && (attr1 = String.valueOf(this.getAttributes())).equals(attr2 = String.valueOf(gto.getAttributes())) && this.elements.size() == gto.elements.size()) {
            for (GroupTreeObject el : this.elements) {
                String type;
                String name = el.getName();
                GroupTreeObject subEl = gto.getChild(name, type = el.getType());
                if (subEl != null && el.isEqualRecursive(subEl)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void mergeAttributesFromTree(GroupTreeObject gto) {
        List<GroupTreeObject> list = gto.getAllElements();
        list.add(gto);
        for (GroupTreeObject gt : list) {
            GroupTreeObject to;
            Map<String, String> attributes = gt.getAttributes();
            if (attributes == null || attributes.size() <= 0 || (to = this.searchPath(gt.getPath(), gt.getType())) == null) continue;
            for (Map.Entry<String, String> en : attributes.entrySet()) {
                to.setAttribute(en.getKey(), en.getValue());
            }
        }
    }

    public static GroupTreeObject createPath(String path, GroupTreeObject newRoot) {
        String[] str = path.split(REGEX_GTO_PATH);
        GroupTreeObject current = newRoot;
        if (str.length > 2) {
            current = newRoot;
            for (int i = 2; i < str.length; ++i) {
                GroupTreeObject g = new GroupTreeObject(new TreeObject(str[i], "", null));
                GroupTreeObject childExist = current.getChild(str[i], "");
                if (childExist == null) {
                    current.addElement(g);
                } else {
                    g = childExist;
                }
                current = g;
            }
        }
        return current;
    }

    public GroupTreeObject searchLongestExistingPath(String path) {
        GroupTreeObject current = null;
        if (path.startsWith("/root/")) {
            current = this.getRoot();
            String[] str = path.split(REGEX_GTO_PATH);
            for (int i = 2; i < str.length; ++i) {
                GroupTreeObject temp = current.getChild(str[i], "");
                if (temp == null) continue;
                current = temp;
            }
        }
        return current;
    }

    @Deprecated
    public static List<GroupTreeObjectLast> collectElements(GroupTreeObject selected) {
        LinkedList<GroupTreeObjectLast> elements = new LinkedList<GroupTreeObjectLast>();
        if (selected.isGroup()) {
            return selected.getAllGTOLs();
        }
        if (!selected.isGroup()) {
            elements.add((GroupTreeObjectLast)selected);
        }
        return elements;
    }

    public static List<GroupTreeObject> collectGroups(GroupTreeObject selected) {
        List<GroupTreeObject> elements = GroupTreeObject._collectGroups(selected);
        elements.remove(selected);
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<GroupTreeObject> _collectGroups(GroupTreeObject selected) {
        LinkedList<GroupTreeObject> elements = new LinkedList<GroupTreeObject>();
        if (selected.isGroup()) {
            elements.add(selected);
            LinkedList<GroupTreeObject> linkedList = elements;
            synchronized (linkedList) {
                Iterator<GroupTreeObject> it = selected.elements.iterator();
                while (it.hasNext()) {
                    List<GroupTreeObject> path = GroupTreeObject._collectGroups(it.next());
                    elements.addAll(path);
                }
            }
        }
        return elements;
    }

    public static List<GroupTreeObject> collectGroupsWithOIDNotNull(GroupTreeObject selected) {
        List<GroupTreeObject> elements = GroupTreeObject._collectGroupsWithOIDNotNull(selected);
        elements.remove(selected);
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GroupTreeObject> _collectGroupsWithOIDNotNull(GroupTreeObject selected) {
        LinkedList<GroupTreeObject> elements = new LinkedList<GroupTreeObject>();
        if (selected.isGroup()) {
            if (selected.getTreeObject() != null && selected.getTreeObject().getOID() != null) {
                elements.add(selected);
            }
            LinkedList<GroupTreeObject> linkedList = elements;
            synchronized (linkedList) {
                Iterator<GroupTreeObject> it = selected.elements.iterator();
                while (it.hasNext()) {
                    List<GroupTreeObject> path = GroupTreeObject._collectGroupsWithOIDNotNull(it.next());
                    elements.addAll(path);
                }
            }
        }
        return elements;
    }

    public static void cleanEmptyGroups(GroupTreeObject selected, GroupTreeObject stopGTO) {
        List<GroupTreeObject> list = GroupTreeObject._collectGroups(selected);
        for (GroupTreeObject groupTreeObject : list) {
            GroupTreeObject upToParent;
            if (groupTreeObject.hasElements().booleanValue() || groupTreeObject.getParent() == null) continue;
            for (upToParent = groupTreeObject; upToParent != null && upToParent.elements.size() == 1 && !upToParent.equals(stopGTO); upToParent = upToParent.getParent()) {
            }
            if (upToParent != null && !stopGTO.equals(upToParent)) {
                GroupTreeObject pu = upToParent.getParent();
                if (pu == null) continue;
                pu.removeElement(upToParent);
                continue;
            }
            groupTreeObject.getParent().removeElement(groupTreeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupTreeObject clone() throws CloneNotSupportedException {
        super.clone();
        TreeObject treeObject = new TreeObject(this.getName(), this.getType(), this.getTreeObject().getObject());
        GroupTreeObject newGTO = new GroupTreeObject(treeObject);
        Map<String, String> attr = this.getAttributes();
        if (attr != null) {
            for (Map.Entry entry : attr.entrySet()) {
                newGTO.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        List<GroupTreeObject> list = this.elements;
        synchronized (list) {
            for (GroupTreeObject child : this.elements) {
                newGTO.addElement(child.clone());
            }
        }
        return newGTO;
    }

    @Override
    public int compareTo(GroupTreeObject o) {
        try {
            return this.m_obj.getComparableName().compareToIgnoreCase(o.m_obj.getComparableName());
        }
        catch (Throwable e) {
            return 1;
        }
    }

    public GroupTreeObject getRoot() {
        GroupTreeObject root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root;
    }

    public GroupTreeObject reverseFind(String name, String type) {
        GroupTreeObject current = this;
        while (current.parent != null) {
            if (current.parent.getName().equals(name) && (current.parent.getType().equals(type) || "".equals(type) && "toplevel".equals(current.parent.getType()))) {
                return current.parent;
            }
            current = current.parent;
        }
        return null;
    }

    public GroupTreeObject reverseFind(String type) {
        GroupTreeObject current = this;
        while (current.parent != null) {
            if (current.parent.getType().equals(type) || "".equals(type) && "toplevel".equals(current.parent.getType())) {
                return current.parent;
            }
            current = current.parent;
        }
        return null;
    }

    public List<String> getAllParentOIDs(GroupTreeObject excludeMe) {
        LinkedList<String> oids = new LinkedList<String>();
        GroupTreeObject parent = excludeMe.getParent();
        if (parent != null) {
            this._getAllParentOIDs(parent, oids);
        }
        return oids;
    }

    private void _getAllParentOIDs(GroupTreeObject gto, List<String> oidList) {
        if (gto.getParent() != null) {
            this._getAllParentOIDs(gto.getParent(), oidList);
        }
        try {
            String oid = gto.getTreeObject().getOID();
            if (oid != null) {
                oidList.add(oid);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean retainAll(GroupTreeObject anotherTree) {
        boolean isChanged = false;
        for (GroupTreeObject gto : new ArrayList<GroupTreeObject>(this.elements)) {
            GroupTreeObject anotherGTO = anotherTree.getChild(gto.getName(), gto.getType());
            if (anotherGTO == null) {
                this.removeElement(gto);
                isChanged = true;
                continue;
            }
            if (!gto.hasElements().booleanValue()) continue;
            isChanged = isChanged || gto.retainAll(anotherGTO);
        }
        return isChanged;
    }

    public String getAttribute(String name) {
        if (this.m_attributes == null) {
            return null;
        }
        return this.m_attributes.get(name);
    }

    public void setAttribute(String name, String value) {
        if (this.m_attributes == null) {
            this.m_attributes = new TreeMap<String, String>();
        }
        this.m_attributes.put(name, value);
    }

    public boolean removeAttribute(String name) {
        boolean res;
        if (this.m_attributes == null) {
            return false;
        }
        boolean bl = res = this.m_attributes.remove(name) != null;
        if (this.m_attributes.size() == 0) {
            this.clearAttributes();
        }
        return res;
    }

    public void clearAttributes() {
        this.m_attributes = null;
    }

    public void clearAttributesRecursive() {
        this.m_attributes = null;
        List<GroupTreeObject> subelements = this.elements;
        if (this.elements != null) {
            for (GroupTreeObject el : subelements) {
                el.clearAttributesRecursive();
            }
        }
    }

    public void clearAttributesRecursive(String attributeName, String attributeValue) {
        Iterator<Map.Entry<String, String>> it = this.m_attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> en = it.next();
            if (!attributeName.equals(en.getKey()) || !attributeValue.equals(en.getValue())) continue;
            it.remove();
        }
        List<GroupTreeObject> subelements = this.elements;
        if (this.elements != null) {
            for (GroupTreeObject el : subelements) {
                el.clearAttributesRecursive(attributeName, attributeValue);
            }
        }
    }

    public void clearAttributesRecursive(String attributeName) {
        if (this.m_attributes != null) {
            Iterator<Map.Entry<String, String>> it = this.m_attributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> en = it.next();
                if (!attributeName.equals(en.getKey())) continue;
                it.remove();
            }
        }
        List<GroupTreeObject> subelements = this.elements;
        if (this.elements != null) {
            for (GroupTreeObject el : subelements) {
                el.clearAttributesRecursive(attributeName);
            }
        }
    }

    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public String findTopAttribute(String attributeName) {
        String attrValue = this.getAttribute(attributeName);
        if (attrValue == null && this.getParent() != null) {
            attrValue = this.getParent().findTopAttribute(attributeName);
        }
        return attrValue;
    }

    public String toPrintString() {
        XMLTree xt = new XMLTree();
        Document d = xt.getXML(this);
        return XMLFactory.writeXml(d);
    }

    public void removeElementsIfAttributeNotSetRecursive(String attributeName, List<String> attributeValues) {
        if (this.hasElements().booleanValue()) {
            for (GroupTreeObject child : new ArrayList<GroupTreeObject>(this.getElements())) {
                String attribute = child.getAttribute(attributeName);
                if (attribute != null && attributeValues.contains(attribute)) continue;
                if (child.hasElements().booleanValue()) {
                    child.removeElementsIfAttributeNotSetRecursive(attributeName, attributeValues);
                }
                if (child.hasElements().booleanValue()) continue;
                this.removeElement(child);
            }
        }
    }

    public List<GroupTreeObject> findElementsByAttribute(String attributeName, String attributeValue) {
        List<GroupTreeObject> elements = this.getAllElements();
        Iterator<GroupTreeObject> it = elements.iterator();
        while (it.hasNext()) {
            String val = it.next().getAttribute(attributeName);
            if (val != null && val.equals(attributeValue)) continue;
            it.remove();
        }
        return elements;
    }

    static String getCanonicalVersion(String str) {
        String canon;
        if (str == null || str.length() > 8 && str.charAt(8) == '-') {
            return str;
        }
        if (map.size() > 10000) {
            map.clear();
        }
        return (canon = map.putIfAbsent(str, str)) == null ? str : canon;
    }

    @Override
    public String getID() {
        return this.getNameType();
    }

    public void setLabel(String label) {
        this.setAttribute(GTOLABEL, label);
    }

    public String getLabel() {
        return this.getAttribute(GTOLABEL);
    }

    public boolean removeLabel() {
        return this.removeAttribute(GTOLABEL);
    }

    private String getLabelForSorting() {
        String label = this.getLabel();
        if (label == null) {
            String string = label = this.getTreeObject() == null ? null : this.getTreeObject().getComparableName();
            if (label == null) {
                label = this.getName();
            }
        }
        return label;
    }

    public boolean isGroup() {
        return true;
    }

    public boolean isUnsubmitted() {
        return false;
    }
}

