/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.ITreeObject;

public class TreeObject
implements ITreeObject {
    private String uniqueName = null;
    private String type = null;
    private Object obj = null;
    private String oid = null;

    public TreeObject(String name, String type, Object obj) {
        this.uniqueName = GroupTreeObject.getCanonicalVersion(name);
        if (type != null) {
            this.type = type.intern();
        }
        this.obj = obj;
    }

    @Override
    public String getName() {
        return this.uniqueName;
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setName(String name) {
        this.uniqueName = GroupTreeObject.getCanonicalVersion(name);
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setObject(Object obj) {
        this.obj = obj;
    }

    @Override
    public String getComparableName() {
        return this.getName();
    }

    public boolean equals(Object treeObj) {
        if (treeObj != null && treeObj instanceof TreeObject) {
            TreeObject to = (TreeObject)treeObj;
            if (this.type == null ? to.type == null : (this.type.equals(to.type) && this.uniqueName == null ? to.uniqueName == null : (this.uniqueName.equals(to.uniqueName) && this.oid == null ? to.oid == null : this.oid.equals(to.oid)))) {
                if (this.obj == to.obj) {
                    return true;
                }
                if (this.obj instanceof String && to.obj instanceof String) {
                    return this.obj.equals(to.obj);
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.uniqueName == null) {
            return 0;
        }
        return this.uniqueName.hashCode();
    }

    @Override
    public String getOID() {
        return this.oid;
    }

    @Override
    public void setOID(String oid) {
        this.oid = oid;
    }
}

