/*
 * Decompiled with CFR 0.152.
 */
package com.boom;

public class AgentInfo {
    private String id;
    private String remoteIP;
    private String hostname;
    private int port;
    private String os;
    public final String socketType;
    public final Boolean enabled;
    public final String agentVersion;
    public final String certificate;
    public Integer hbInterval;
    public Boolean offerDataToAnyClusterNode;
    public Boolean actionsEnabled;
    public Boolean deploymentEnabled;
    public Boolean useFixHostname;
    public Boolean useFixIP;
    public Boolean isTlsActive;
    public Integer currentMode;

    public AgentInfo(String socketType, Boolean enabled, String agentVersion, String certificate) {
        this.socketType = socketType;
        this.enabled = enabled;
        this.agentVersion = agentVersion;
        this.certificate = certificate;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSocket() {
        return "SOCKET".equals(this.socketType);
    }

    public boolean isTLS() {
        return this.socketType != null && this.socketType.startsWith("TLS");
    }

    public boolean isHTTP() {
        return "HTTP".equals(this.socketType);
    }

    public boolean isHTTPS() {
        return "HTTPS".equals(this.socketType);
    }

    public boolean isWS() {
        return "WS".equals(this.socketType);
    }

    public boolean isWSS() {
        return "WSS".equals(this.socketType);
    }

    public boolean isTLSReady() {
        return "TLS_READY".equals(this.socketType);
    }

    public boolean isTLSCapable() {
        return "TLS_CAPABLE".equals(this.socketType);
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getFlags() {
        if (this.isTLS()) {
            return 64;
        }
        if (this.isHTTP()) {
            return 32;
        }
        if (this.isHTTPS()) {
            return 128;
        }
        if (this.isWS()) {
            return 256;
        }
        if (this.isWSS()) {
            return 512;
        }
        return 0;
    }

    public String getRemoteIP() {
        return this.remoteIP;
    }

    public void setRemoteIP(String remoteIP) {
        this.remoteIP = remoteIP;
    }

    public String getSocketType() {
        return this.socketType;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public Integer getHbInterval() {
        return this.hbInterval;
    }

    public void setHbInterval(Integer hbInterval) {
        this.hbInterval = hbInterval;
    }

    public Boolean getOfferDataToAnyClusterNode() {
        return this.offerDataToAnyClusterNode;
    }

    public void setOfferDataToAnyClusterNode(Boolean offerDataToAnyClusterNode) {
        this.offerDataToAnyClusterNode = offerDataToAnyClusterNode;
    }

    public Boolean getActionsEnabled() {
        return this.actionsEnabled;
    }

    public void setActionsEnabled(Boolean actionsEnabled) {
        this.actionsEnabled = actionsEnabled;
    }

    public Boolean getDeploymentEnabled() {
        return this.deploymentEnabled;
    }

    public void setDeploymentEnabled(Boolean deploymentEnabled) {
        this.deploymentEnabled = deploymentEnabled;
    }

    public Boolean getUseFixHostname() {
        return this.useFixHostname;
    }

    public void setUseFixHostname(Boolean useFixHostname) {
        this.useFixHostname = useFixHostname;
    }

    public Boolean getUseFixIP() {
        return this.useFixIP;
    }

    public void setUseFixIP(Boolean useFixIP) {
        this.useFixIP = useFixIP;
    }

    public Boolean getTlsActive() {
        return this.isTlsActive;
    }

    public void setTlsActive(Boolean tlsActive) {
        this.isTlsActive = tlsActive;
    }

    public Integer getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(Integer currentMode) {
        this.currentMode = currentMode;
    }

    public String toString() {
        return "AgentInfo{id='" + this.id + "', remoteIP='" + this.remoteIP + "', hostname='" + this.hostname + "', port=" + this.port + ", os='" + this.os + "', socketType='" + this.socketType + "', enabled=" + this.enabled + ", agentVersion='" + this.agentVersion + "', certificate='" + this.certificate + "'}";
    }
}

