/*
 * Decompiled with CFR 0.152.
 */
package com.boom;

import com.boom.crt.CertificateManager;
import java.io.IOException;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TlsUtils {
    private TlsUtils() {
    }

    public static Socket upgradeClientSocket(Socket originalClientSocket, CertificateManager cm, boolean trustAllCertificates) throws IOException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        SSLSocketFactory sslSocketFactory = TlsUtils.getSslSocketFactory(cm, trustAllCertificates);
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(originalClientSocket, originalClientSocket.getInetAddress().getHostAddress(), originalClientSocket.getPort(), true);
        sslSocket.setUseClientMode(true);
        sslSocket.startHandshake();
        return sslSocket;
    }

    public static Socket upgradeClientSocket(Socket originalClientSocket, CertificateManager cm) throws IOException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        return TlsUtils.upgradeClientSocket(originalClientSocket, cm, false);
    }

    public static Socket upgradeServerSocket(Socket originalServerSocket, CertificateManager cm, boolean needClientAuth, boolean trustAllCertificates) throws IOException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        SSLSocketFactory sslSocketFactory = TlsUtils.getSslSocketFactory(cm, trustAllCertificates);
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(originalServerSocket, originalServerSocket.getInetAddress().getHostAddress(), originalServerSocket.getPort(), true);
        sslSocket.setUseClientMode(false);
        sslSocket.setNeedClientAuth(needClientAuth);
        sslSocket.startHandshake();
        return sslSocket;
    }

    public static SSLSocketFactory getSslSocketFactory(CertificateManager cm, boolean trustAllCertificates) throws NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, KeyStoreException {
        SSLContext sscContext = TlsUtils.getSslContext(cm, trustAllCertificates);
        return sscContext.getSocketFactory();
    }

    public static SSLServerSocketFactory getSslServerSocketFactory(CertificateManager cm, boolean trustAllCertificates) throws NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, KeyStoreException {
        SSLContext sscContext = TlsUtils.getSslContext(cm, trustAllCertificates);
        return sscContext.getServerSocketFactory();
    }

    private static SSLContext getSslContext(CertificateManager cm, boolean trustAllCertificates) throws NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, KeyStoreException {
        TrustManager[] trustManagerArray;
        SSLContext sscContext = SSLContext.getInstance("TLSv1.2");
        TrustManager[] trustManagers = Arrays.copyOf(cm.getTrustManagers(), cm.getKeyManagers().length + 1);
        trustManagers[cm.getTrustManagers().length] = TlsUtils.getTrustAllManager();
        KeyManager[] keyManagerArray = cm.getKeyManagers();
        if (trustAllCertificates) {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = TlsUtils.getTrustAllManager();
        } else {
            trustManagerArray = cm.getTrustManagers();
        }
        sscContext.init(keyManagerArray, trustManagerArray, null);
        return sscContext;
    }

    private static TrustManager getTrustAllManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    public static boolean agentNeedsCACertUpdate(CertificateManager cm, Socket socket) throws SSLPeerUnverifiedException, KeyStoreException {
        Certificate latestCACertificate;
        Certificate agentCACert;
        Certificate[] peerCertificates;
        boolean result = false;
        if (socket instanceof SSLSocket && (peerCertificates = ((SSLSocket)socket).getSession().getPeerCertificates()).length > 1 && !TlsUtils.isCertificateSignedBy(agentCACert = peerCertificates[peerCertificates.length - 1], latestCACertificate = cm.getTsClient().getLatestCACertificate())) {
            result = true;
        }
        return result;
    }

    public static boolean isAgentCertAboutToExpire(Socket socket, int thresholdDays) throws SSLPeerUnverifiedException {
        Certificate[] peerCertificates;
        boolean result = false;
        if (socket instanceof SSLSocket && (peerCertificates = ((SSLSocket)socket).getSession().getPeerCertificates()).length >= 1) {
            Certificate agentCACert = peerCertificates[0];
            if (agentCACert instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)agentCACert;
                Date notAfter = x509Certificate.getNotAfter();
                result = notAfter.getTime() - TimeUnit.DAYS.toMillis(thresholdDays) < System.currentTimeMillis();
            }
            return result;
        }
        return result;
    }

    public static boolean isCertificateSignedBy(Certificate certChild, Certificate certParent) {
        boolean result = true;
        try {
            certChild.verify(certParent.getPublicKey());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            result = false;
        }
        return result;
    }
}

