/*
 * Decompiled with CFR 0.152.
 */
package com.boom.crt;

import com.blixx.log.RTLogger;
import com.blixx.server.jetty.JettyMain;
import com.blixx.shared.io.ByteArray;
import com.boom.crt.GeneralNameParsingException;
import com.boom.crt.KeyStoreClient;
import com.boom.crt.KeyStoreCreationException;
import com.boom.crt.KeyStoreLoadingException;
import com.boom.crt.KeyStoreRollbackException;
import com.boom.crt.KeysStoreSwitchException;
import com.boom.crt.TrustStoreClient;
import com.boom.crt.hlp.KeyStoreUtils;
import com.boom.crt.hlp.SubjectAlternativeNameEntry;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.util.ssl.KeyStoreScanner;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class CertificateManager {
    public static final String AGENT_CRT_ALIAS = "agent";
    public static final String SERVER_CERT_ALIAS = "server";
    private KeyStoreClient ksClient = null;
    private TrustStoreClient tsClient = null;

    public CertificateManager() {
    }

    public CertificateManager(KeyStoreClient ksClient, TrustStoreClient tsClient) {
        this.ksClient = ksClient;
        this.tsClient = tsClient;
    }

    public void initTrustStore(String tsFile, String tsPassEncoded) throws Exception {
        if (tsFile != null) {
            Path trustStorePath = Paths.get(tsFile, new String[0]);
            this.tsClient = new TrustStoreClient(KeyStoreUtils.getKeyStoreType(tsFile), trustStorePath, tsPassEncoded);
            if (!Files.exists(trustStorePath, new LinkOption[0])) {
                this.tsClient.createKeyStore();
                RTLogger.print(3, "Truststore created");
            } else {
                this.tsClient.loadKeyStore();
                if (this.tsClient.getKeyStore().size() == 0) {
                    Thread.sleep(100L);
                    this.tsClient.loadKeyStore();
                }
                RTLogger.print(3, "Truststore loaded");
            }
        } else {
            RTLogger.print(1, "Truststore is not defined");
        }
    }

    public Optional<ByteArray> initServerKeyStore(String hostname, String mainServerName, String mainServerIP, String ksFile, String ksPassEncoded, Collection<String> allIPs, Collection<String> allHostnames) throws Exception {
        Optional<ByteArray> result = Optional.empty();
        if (ksFile != null) {
            Path keyStorePath = Paths.get(ksFile, new String[0]);
            this.ksClient = new KeyStoreClient(KeyStoreUtils.getKeyStoreType(ksFile), keyStorePath, ksPassEncoded);
            if (!Files.exists(keyStorePath, new LinkOption[0])) {
                Collection<String> sanIPs;
                RTLogger.print(3, "Creating server keystore " + String.valueOf(keyStorePath.toAbsolutePath()));
                this.ksClient.createKeyStore();
                if (this.isEmpty(mainServerIP)) {
                    sanIPs = allIPs;
                } else {
                    sanIPs = new HashSet<String>(allIPs);
                    sanIPs.add(mainServerIP);
                }
                List<SubjectAlternativeNameEntry> sans = KeyStoreUtils.getSubjectAlternativeNameEntries(sanIPs, allHostnames);
                String hostnameToUseInCN = this.isEmpty(mainServerName) ? hostname : mainServerName;
                byte[] csr = this.generateServerCerts(hostnameToUseInCN, sans);
                result = Optional.of(new ByteArray(csr));
            } else {
                this.ksClient.loadKeyStore();
                RTLogger.print(3, "Server keystore loaded");
                if (!this.ksClient.getKeyStore().containsAlias(SERVER_CERT_ALIAS)) {
                    Thread.sleep(100L);
                    this.ksClient.loadKeyStore();
                    if (!this.ksClient.getKeyStore().containsAlias(SERVER_CERT_ALIAS)) {
                        throw new Exception("KeyStore does not contain server certificate. Expected alias: server. You can delete keystore to re-generate keystore");
                    }
                }
            }
        } else {
            RTLogger.print(1, "Keystore is not defined");
        }
        return result;
    }

    public synchronized void initAgentKeyStore(String alias, String hostname, String ksFile, String ksPassEncoded, Collection<String> allIPs, Collection<String> allHostnames) throws Exception {
        if (ksFile != null) {
            Path keyStorePath = Paths.get(ksFile, new String[0]);
            List<SubjectAlternativeNameEntry> sans = KeyStoreUtils.getSubjectAlternativeNameEntries(allIPs, allHostnames);
            this.ksClient = new KeyStoreClient(KeyStoreUtils.getKeyStoreType(ksFile), keyStorePath, ksPassEncoded);
            if (!Files.exists(keyStorePath, new LinkOption[0])) {
                try {
                    RTLogger.print(3, "Creating agent keystore " + String.valueOf(keyStorePath.toAbsolutePath()) + " " + String.valueOf(this));
                    this.ksClient.createKeyStore();
                    this.ksClient.generateAndImportSelfSignedCertificate(alias, "CN=" + hostname, 700, "SHA256WithRSA", false, sans, false);
                    this.ksClient.saveKeyStore();
                    RTLogger.print(3, "Self signed agent certificate has been created " + String.valueOf(this));
                }
                catch (Exception e) {
                    throw new KeyStoreCreationException("Could not create keystore " + String.valueOf(keyStorePath.toAbsolutePath()), e);
                }
            } else {
                try {
                    this.ksClient.loadKeyStore();
                    RTLogger.print(4, "Start loading Agent keystore " + ksFile);
                    if (!this.ksClient.getKeyStore().containsAlias(alias)) {
                        Thread.sleep(100L);
                        this.ksClient.loadKeyStore();
                        if (!this.ksClient.getKeyStore().containsAlias(alias)) {
                            throw new Exception("KeyStore does not contain agent certificate. Expected alias: " + alias + ". You can delete keystore to re-generate keystore " + String.valueOf(keyStorePath) + " " + String.valueOf(this));
                        }
                    }
                    RTLogger.print(3, "Agent keystore " + ksFile + " has been loaded");
                }
                catch (Exception e) {
                    throw new KeyStoreLoadingException("Could not load keystore " + String.valueOf(keyStorePath.toAbsolutePath()), e);
                }
            }
        } else {
            RTLogger.print(1, "Keystore is not defined");
        }
    }

    public CertPathValidatorResult checkTrustStoreCertificate(String alias, boolean revocationEnabled) throws CertificateException, CertPathValidatorException, InvalidAlgorithmParameterException, KeyStoreException, NoSuchAlgorithmException {
        PKIXBuilderParameters params = new PKIXBuilderParameters(this.tsClient.getKeyStore(), (CertSelector)new X509CertSelector());
        params.setRevocationEnabled(revocationEnabled);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate certificate = this.tsClient.getKeyStore().getCertificate(alias);
        if (certificate == null) {
            throw new CertPathValidatorException("Certificate with alias " + alias + " not found.");
        }
        CertPath cp = cf.generateCertPath(Collections.singletonList(certificate));
        CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
        return cpv.validate(cp, params);
    }

    public CertPathValidatorResult checkKeyStoreCertificate(String alias, boolean revocationEnabled) throws CertificateException, CertPathValidatorException, InvalidAlgorithmParameterException, KeyStoreException, NoSuchAlgorithmException {
        PKIXBuilderParameters params = new PKIXBuilderParameters(this.tsClient.getKeyStore(), (CertSelector)new X509CertSelector());
        params.setRevocationEnabled(revocationEnabled);
        return this.checkCertificate(this.ksClient.getKeyStore(), alias, params);
    }

    public boolean isCertificateSignedByTheLatestCA(String alias) throws KeyStoreException {
        boolean result = false;
        Certificate[] chain = this.ksClient.getKeyStore().getCertificateChain(alias);
        Optional<String> latestCAAlias = KeyStoreUtils.getLatestCAAlias(this.tsClient);
        if (chain.length > 1 && latestCAAlias.isPresent()) {
            result = Objects.equals(chain[chain.length - 1], this.tsClient.getKeyStore().getCertificate(latestCAAlias.get()));
        }
        return result;
    }

    public CertPathValidatorResult checkCertificate(KeyStore keyStore, String alias, PKIXBuilderParameters params) throws CertificateException, CertPathValidatorException, InvalidAlgorithmParameterException, KeyStoreException, NoSuchAlgorithmException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate[] certArray = keyStore.getCertificateChain(alias);
        CertPath cp = cf.generateCertPath(Arrays.asList(certArray));
        CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
        return cpv.validate(cp, params);
    }

    private byte[] generateServerCerts(String hostname, List<SubjectAlternativeNameEntry> sans) throws GeneralSecurityException, IOException, GeneralNameParsingException {
        this.ksClient.generateAndImportSelfSignedCertificate(SERVER_CERT_ALIAS, "CN=" + hostname, 700, "SHA256WithRSA", false, sans, false);
        this.ksClient.saveKeyStore();
        RTLogger.print(3, "Server self signed certificate has been created");
        byte[] request = this.ksClient.createCertificateRequest(SERVER_CERT_ALIAS, false, sans);
        RTLogger.print(3, "Sending CSR for server certificate");
        return request;
    }

    private String getFileNameExtension(String name) {
        int index = name.lastIndexOf(46);
        String result = index >= 0 ? name.substring(index + 1) : "";
        return result;
    }

    public void storeServerCertificate(byte[] signedServerCert) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableEntryException {
        KeyStoreClient keyStoreClientToUse;
        boolean usePrimaryKeyStore = this.ksClient.isSelfSignedCertificate(SERVER_CERT_ALIAS);
        if (usePrimaryKeyStore) {
            keyStoreClientToUse = this.ksClient;
        } else {
            keyStoreClientToUse = this.getRenewalKeyStore();
            keyStoreClientToUse.loadKeyStore();
            if (keyStoreClientToUse.keyStore.size() == 0) {
                Thread.yield();
                keyStoreClientToUse.loadKeyStore();
            }
        }
        keyStoreClientToUse.importPrivateKeyCertificate(SERVER_CERT_ALIAS, signedServerCert);
        RTLogger.print(3, "Server certificate imported");
        keyStoreClientToUse.saveKeyStore();
        if (!usePrimaryKeyStore) {
            Certificate renewalCaCert;
            Certificate primaryCaCert;
            Certificate[] primaryCertChain = this.ksClient.getKeyStore().getCertificateChain(SERVER_CERT_ALIAS);
            Certificate[] renewalCertChain = keyStoreClientToUse.getKeyStore().getCertificateChain(SERVER_CERT_ALIAS);
            if (primaryCertChain != null && renewalCertChain != null && Objects.equals(primaryCaCert = primaryCertChain[primaryCertChain.length - 1], renewalCaCert = renewalCertChain[renewalCertChain.length - 1])) {
                RTLogger.print(1, "New server certificate was signed by the same CA as the current one. Performing key store switch.");
                try {
                    this.switchKeyStores();
                    RTLogger.print(1, "Key store switch successfully completed.");
                }
                catch (KeyStoreRollbackException | KeysStoreSwitchException e) {
                    RTLogger.print(1, "Could not perform key store switch", e);
                }
            }
        }
    }

    private void importTrustedCertificatesForServerCert(byte[] signedServerCert) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(signedServerCert));){
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            while (bis.available() > 0) {
                Certificate cert = cf.generateCertificate(bis);
                certificates.add(cert);
            }
            int certificatesCount = certificates.size();
            if (certificatesCount > 1) {
                certificates.remove(0);
                RTLogger.print(3, "Importing " + certificatesCount + " CA certificate(s) into trust store");
                KeyStoreUtils.importTrustedCACertificatesIgnoringDuplicates(certificates, this.tsClient);
            }
        }
        this.tsClient.saveKeyStore();
    }

    public void switchKeyStores() throws KeysStoreSwitchException, KeyStoreRollbackException {
        Path keyStorePath = this.getKsClient().getKeyStorePath();
        Path bkpKeyStorePath = this.getBackedUpKeyStore().getKeyStorePath();
        KeyStoreClient renewalKeyStore = this.getRenewalKeyStore();
        Path renewalKeyStorePath = renewalKeyStore.getKeyStorePath();
        try {
            renewalKeyStore.loadKeyStore();
            boolean selfSignedCertificate = renewalKeyStore.isSelfSignedCertificate(SERVER_CERT_ALIAS);
            if (selfSignedCertificate) {
                throw new KeysStoreSwitchException("Server certificate in renewal keystore is not signed");
            }
        }
        catch (Exception e) {
            throw new KeysStoreSwitchException("Could not load renewal keystore");
        }
        try {
            RTLogger.print(1, "Starting backup original keystore mv " + String.valueOf(keyStorePath) + " " + String.valueOf(bkpKeyStorePath));
            Files.move(keyStorePath, bkpKeyStorePath, StandardCopyOption.REPLACE_EXISTING);
            try {
                RTLogger.print(1, "Replacing original keystore mv " + String.valueOf(renewalKeyStorePath) + " " + String.valueOf(keyStorePath));
                Files.move(renewalKeyStorePath, keyStorePath, StandardCopyOption.REPLACE_EXISTING);
                this.getKsClient().loadKeyStore();
                RTLogger.print(1, "Successfully switched key stores");
                try {
                    new KeyStoreScanner((SslContextFactory)JettyMain.sslContextFactory).reload();
                }
                catch (Exception e) {
                    RTLogger.print(1, "FileScanner failed to reload certificate for Jetty", e);
                }
            }
            catch (Exception e) {
                try {
                    Files.move(bkpKeyStorePath, keyStorePath, StandardCopyOption.REPLACE_EXISTING);
                    this.getKsClient().loadKeyStore();
                    throw new KeysStoreSwitchException("Could not switch key stores continue using the existing one.", e);
                }
                catch (Exception e1) {
                    throw new KeyStoreRollbackException("Failed to restore the keystore from backup.", e1);
                }
            }
        }
        catch (IOException e) {
            throw new KeysStoreSwitchException("Switch of key stores has failed continue using the existing one.", e);
        }
    }

    public KeyStoreClient getRenewalKeyStore() {
        Path defaultKeyStorePath = this.ksClient.getKeyStorePath();
        String defaultKeyStoreFileName = defaultKeyStorePath.getFileName().toString();
        Path path = defaultKeyStorePath.toAbsolutePath().getParent().resolve("keystore_renewal." + this.getFileNameExtension(defaultKeyStoreFileName));
        return new KeyStoreClient(KeyStoreUtils.getKeyStoreType(defaultKeyStoreFileName), path, this.ksClient.getPwdEncrypted());
    }

    public KeyStoreClient getBackedUpKeyStore() {
        Path defaultKeyStorePath = this.ksClient.getKeyStorePath();
        String defaultKeyStoreFileName = defaultKeyStorePath.getFileName().toString();
        Path path = KeyStoreUtils.getBackupPath(defaultKeyStorePath);
        return new KeyStoreClient(KeyStoreUtils.getKeyStoreType(defaultKeyStoreFileName), path, this.ksClient.getPwdEncrypted());
    }

    public KeyStoreClient getKsClient() {
        return this.ksClient;
    }

    public TrustStoreClient getTsClient() {
        return this.tsClient;
    }

    public TrustManager[] getTrustManagers() throws KeyStoreException, NoSuchAlgorithmException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(this.tsClient == null ? null : this.tsClient.getKeyStore());
        return tmf.getTrustManagers();
    }

    public KeyManager[] getKeyManagers() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(this.ksClient == null ? null : this.ksClient.getKeyStore(), this.ksClient == null ? null : this.ksClient.getPwdArray());
        return kmf.getKeyManagers();
    }

    public boolean isKnownAgent(String agentId) throws NullPointerException, KeyStoreException, CertificateException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        boolean agentKnown = false;
        if (this.tsClient == null) {
            RTLogger.print(1, "Agent certificate check failed. Trust store client is null");
        } else {
            KeyStore keyStore = this.tsClient.getKeyStore();
            if (keyStore == null) {
                RTLogger.print(1, "Agent certificate check failed. Trust store is null");
            } else if (keyStore.containsAlias(agentId)) {
                try {
                    this.checkTrustStoreCertificate(agentId, false);
                    agentKnown = true;
                }
                catch (CertPathValidatorException e) {
                    RTLogger.print(1, "Agent certificate check failed " + KeyStoreUtils.getHumanReadableVerificationResult(e) + " " + agentId, e);
                }
            }
        }
        return agentKnown;
    }

    public boolean isValidCertificate(byte[] certBytes, boolean revocationEnabled) {
        PKIXBuilderParameters params = null;
        try {
            params = new PKIXBuilderParameters(this.tsClient.getKeyStore(), (CertSelector)new X509CertSelector());
            params.setRevocationEnabled(revocationEnabled);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(certBytes));
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            while (bis.available() > 0) {
                Certificate cert = cf.generateCertificate(bis);
                certificates.add(cert);
            }
            CertPath cp = cf.generateCertPath(certificates);
            CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
            cpv.validate(cp, params);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }
}

