/*
 * Decompiled with CFR 0.152.
 */
package com.boom.crt.hlp;

import com.boom.crt.hlp.SubjectAlternativeNameEntry;
import com.boom.crt.hlp.SubjectAlternativeNameExtension;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class BasicCertificateInfo {
    private X509Certificate certificate;
    private String alias;
    private Date validFrom;
    private Date validTo;
    private String subjectName;
    private String issuerName;
    private String fingerprintSha1 = null;
    private String fingerprintSha256 = null;
    private List<SubjectAlternativeNameEntry> alternativeNames = new ArrayList<SubjectAlternativeNameEntry>();

    public BasicCertificateInfo(String alias, X509Certificate certificate) throws CertificateParsingException {
        this.certificate = certificate;
        this.alias = alias;
        this.validFrom = certificate.getNotBefore();
        this.validTo = certificate.getNotAfter();
        this.subjectName = certificate.getSubjectX500Principal().getName();
        this.issuerName = certificate.getIssuerDN().getName();
        this.collectAlternativeNames();
    }

    private void collectAlternativeNames() throws CertificateParsingException {
        Collection<List<?>> altNames = this.certificate.getSubjectAlternativeNames();
        if (altNames != null) {
            for (List<?> altName : altNames) {
                if (altName.size() != 2) continue;
                switch ((Integer)altName.get(0)) {
                    case 1: {
                        this.alternativeNames.add(new SubjectAlternativeNameEntry(SubjectAlternativeNameExtension.EMAIL, altName.get(1).toString()));
                        break;
                    }
                    case 2: {
                        this.alternativeNames.add(new SubjectAlternativeNameEntry(SubjectAlternativeNameExtension.DNS, altName.get(1).toString()));
                        break;
                    }
                    case 6: {
                        this.alternativeNames.add(new SubjectAlternativeNameEntry(SubjectAlternativeNameExtension.URI, altName.get(1).toString()));
                        break;
                    }
                    case 7: {
                        this.alternativeNames.add(new SubjectAlternativeNameEntry(SubjectAlternativeNameExtension.IP, altName.get(1).toString()));
                        break;
                    }
                    case 8: {
                        this.alternativeNames.add(new SubjectAlternativeNameEntry(SubjectAlternativeNameExtension.OID, altName.get(1).toString()));
                        break;
                    }
                }
            }
        }
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getAlias() {
        return this.alias;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public List<SubjectAlternativeNameEntry> getAlternativeNames() {
        return this.alternativeNames;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public String getSHA1Fingerprint() {
        if (this.fingerprintSha1 == null && this.certificate != null) {
            try {
                this.fingerprintSha1 = BasicCertificateInfo.getFingerprint(this.certificate, "SHA-1");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fingerprintSha1;
    }

    public String getSHA256Fingerprint() {
        if (this.fingerprintSha256 == null && this.certificate != null) {
            try {
                this.fingerprintSha256 = BasicCertificateInfo.getFingerprint(this.certificate, "SHA-256");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fingerprintSha256;
    }

    private static String getFingerprint(X509Certificate cert, String hashType) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance(hashType);
        md.update(cert.getEncoded());
        byte[] digest = md.digest();
        String digestHex = new BigInteger(1, digest).toString(16);
        return BasicCertificateInfo.insertCharEveryNChars(digestHex, ':', 2);
    }

    private static String insertCharEveryNChars(String hash, char splitter, int n) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < hash.length(); ++i) {
            builder.append(hash.charAt(i));
            if (i % n != 1 || i >= hash.length() - 1) continue;
            builder.append(splitter);
        }
        return builder.toString();
    }

    public String toString() {
        String str = "BasicCertificateInfo{alias='" + this.alias + "', validFrom=" + String.valueOf(this.validFrom) + ", validTo=" + String.valueOf(this.validTo) + ", subjectName='" + this.subjectName + "'";
        return str;
    }
}

