/*
 * Decompiled with CFR 0.152.
 */
package com.boom.crt.hlp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FileModificationChecker {
    private long ignoreCheckIntervalMs = 10000L;
    private Path path;
    private long lastCheckMs = 0L;
    private long lastModifiedMs = 0L;

    public FileModificationChecker(Path path) {
        this.path = path;
        try {
            this.lastModifiedMs = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public FileModificationChecker(Path path, long ignoreCheckIntervalMs) {
        this.path = path;
        this.ignoreCheckIntervalMs = ignoreCheckIntervalMs;
        this.isFileChanged();
    }

    public boolean isChanged() {
        boolean result = false;
        long currentMs = System.currentTimeMillis();
        if (this.lastCheckMs + this.ignoreCheckIntervalMs < currentMs) {
            result = this.isFileChanged();
            this.lastCheckMs = currentMs;
        } else {
            result = false;
        }
        return result;
    }

    private boolean isFileChanged() {
        boolean result = false;
        try {
            long currentLastModifiedMs = Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
            if (currentLastModifiedMs != this.lastModifiedMs) {
                result = true;
                this.lastModifiedMs = currentLastModifiedMs;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

