/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli;

import com.boom.server.cli.CliCommandFactory;
import com.boom.server.cli.CliInput;
import com.boom.server.cli.CliServerConnection;
import com.boom.server.cli.GeneralHelp;
import com.boom.server.cli.StrUtils;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.ExceptionWithExitCode;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.UnknownCommandException;
import com.boom.server.cli.exceptions.UnknownFlagException;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class Cli {
    private static boolean exit = true;
    private static StringBuilder msg = new StringBuilder();
    private static int resultCode = 0;
    public static final String VERSION = "5.11.0";

    public static void main(String[] args) {
        Cli.initMsg();
        CliServerConnection serverConnection = new CliServerConnection();
        CliInput command = new CliInput();
        if (args.length == 0) {
            Cli.addMsg(GeneralHelp.getGeneralHelp());
        }
        if (args.length == 1 && (args[0].equals("-version") || args[0].equals("-v"))) {
            Cli.addMsg("boom CLI version 5.11.0");
        } else {
            try {
                Cli.parseCmdInput(args, serverConnection, command);
                Cli.runCommand(command, serverConnection);
            }
            catch (UnknownFlagException e) {
                Cli.addMsg("flag " + e.getCommand() + " is invalid!");
                Cli.addMsg(GeneralHelp.getGeneralHelp());
                Cli.setResultCode(e.getCode());
            }
            catch (UnknownCommandException e) {
                if (command.getCommand() == null) {
                    Cli.addMsg("No command was parsed!");
                } else {
                    Cli.addMsg("Unknown command: " + command.getCommand());
                }
                Cli.addMsg(GeneralHelp.getGeneralHelp());
                Cli.setResultCode(e.getCode());
            }
            catch (ExceptionWithExitCode e) {
                Cli.addMsg(e.getMessage());
                Cli.setResultCode(e.getCode());
            }
            catch (FileNotFoundException e) {
                Cli.addMsg("File could not be found!");
                Cli.addMsg(e.getMessage());
                Cli.setResultCode(-8);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Cli.addMsg("A flag was set but no input provided.");
                Cli.setResultCode(-99);
            }
            catch (Exception e) {
                Cli.addMsg(e.getMessage());
                Cli.setResultCode(-99);
            }
        }
        Cli.exitCommand();
    }

    public static void parseCmdInput(String[] args, CliServerConnection srvCon, CliInput cmd) throws UnknownFlagException, InvalidInputException, FileNotFoundException {
        if (Files.exists(Paths.get("boom_cli.cfg", new String[0]), new LinkOption[0])) {
            srvCon.readConfigFile("boom_cli.cfg");
        }
        block44: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "": {
                    continue block44;
                }
                case "-h": {
                    cmd.setHelpFlag();
                    if (cmd.getCommand() != null || i + 1 >= args.length || args[i + 1].startsWith("-")) continue block44;
                    cmd.setCommand(args[++i]);
                    continue block44;
                }
                case "-f": {
                    srvCon.setByCfg(new StrUtils().removeQuotesStrict(args[++i]));
                    continue block44;
                }
                case "-c": {
                    cmd.setCommand(new StrUtils().removeQuotesStrict(args[++i]));
                    continue block44;
                }
                case "-cc": {
                    cmd.setAction(new StrUtils().removeQuotesStrict(args[++i]));
                    continue block44;
                }
                case "-a": {
                    cmd.appendParameters(new StrUtils().removeQuotesStrict(args[++i]));
                    continue block44;
                }
                case "-u": {
                    srvCon.setUser(args[++i]);
                    continue block44;
                }
                case "-p": {
                    srvCon.setPass(args[++i]);
                    continue block44;
                }
                case "-s": {
                    srvCon.setHost(args[++i]);
                    continue block44;
                }
                case "-t": {
                    try {
                        srvCon.setPort(Integer.parseInt(args[++i]));
                        continue block44;
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidInputException("The port number parsed could not be converted from String to number.");
                    }
                }
                case "-x": {
                    cmd.setSeparator(args[++i]);
                    continue block44;
                }
                case "-ru": {
                    continue block44;
                }
                case "-rp": {
                    continue block44;
                }
                case "-rc": {
                    continue block44;
                }
                case "-rcc": {
                    continue block44;
                }
                case "-ra": {
                    continue block44;
                }
                case "-rs": {
                    continue block44;
                }
                case "-l": {
                    continue block44;
                }
                case "-fs": {
                    srvCon.setPathForConfigStore(args[++i]);
                    continue block44;
                }
                default: {
                    if (args[i].startsWith("--")) {
                        cmd.getNamedParameters().put(args[i].substring(2), new StrUtils().removeQuotesStrict(args[++i]));
                        continue block44;
                    }
                    throw new UnknownFlagException(args[i]);
                }
            }
        }
    }

    public static void runCommand(CliInput cmd, CliServerConnection srvCon) throws UnknownCommandException, InvalidInputException, CommandProcessingException {
        if (srvCon.getPathForConfigStore() != null) {
            srvCon.storeConfig();
        } else if (cmd.getHelpFlag()) {
            AbstractCommand cmdClass = null;
            try {
                if (cmd.getCommand() != null && cmd.getCommand().equals("ACTION")) {
                    Cli.prepareInputsForAction(cmd);
                }
                cmdClass = new CliCommandFactory().getCommand(cmd.getCommand(), cmd.getAction(), cmd.getParameters(), cmd.getNamedParameters(), cmd.getSeparator(), srvCon.getServerAuth());
                Cli.addMsg(cmdClass.getUsage());
            }
            catch (UnknownCommandException e) {
                Cli.addMsg(GeneralHelp.getGeneralHelp());
            }
            catch (IllegalArgumentException e) {
                throw new UnknownCommandException(cmd.getCommand());
            }
        } else {
            try {
                AbstractCommand cmdClass = new CliCommandFactory().getCommand(cmd.getCommand(), cmd.getAction(), cmd.getParameters(), cmd.getNamedParameters(), cmd.getSeparator(), srvCon.getServerAuth());
                CommandResult commandResult = srvCon.connectAndRun(cmdClass);
                Cli.addMsg(commandResult.getOutput());
                Cli.setResultCode(commandResult.getCode());
            }
            catch (IllegalArgumentException e) {
                throw new UnknownCommandException(cmd.getCommand());
            }
        }
    }

    public static void prepareInputsForAction(CliInput cmd) throws InvalidInputException {
        if (cmd.getAction() == null) {
            cmd.setAction("help");
        }
        if (cmd.getParameters().size() != 2) {
            if (cmd.getParameters().isEmpty()) {
                cmd.appendParameters("help");
                cmd.appendParameters("1");
            } else if (cmd.getParameters().size() == 1) {
                cmd.appendParameters("1");
            } else {
                throw new InvalidInputException("Exactly 2 parameters have to be parsed!");
            }
        }
    }

    public static void exitCommand() {
        if (exit) {
            System.out.println(Cli.getMsg().trim());
            System.exit(resultCode);
        }
    }

    public static String getMsg() {
        return msg.toString();
    }

    public static void addMsg(String msg1) {
        if (msg1 != null) {
            if (msg.length() == 0) {
                msg.append(msg1);
            } else {
                msg.append("\n").append(msg1);
            }
        }
    }

    public static void initMsg() {
        msg = new StringBuilder();
    }

    public static void setExit(boolean exit) {
        Cli.exit = exit;
    }

    public static int getResultCode() {
        return resultCode;
    }

    public static void setResultCode(int resultCode) {
        Cli.resultCode = resultCode;
    }
}

