/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli;

import com.boom.server.cli.exceptions.InvalidInputException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CliInput {
    private String command = null;
    private String action = null;
    private List<String> parameters = new ArrayList<String>();
    private Map<String, String> namedParameters = new HashMap<String, String>();
    private boolean helpFlag = false;
    public static String separator = "\t";

    public String getSeparator() {
        return separator;
    }

    public void setSeparator(String separator) {
        CliInput.separator = separator.endsWith("\"") && separator.startsWith("\"") ? separator.substring(1, separator.length() - 1) : separator;
    }

    public void setCommand(String command) throws InvalidInputException {
        if (this.command != null) {
            throw new InvalidInputException(command + " is defined twice!");
        }
        this.command = command;
    }

    public void setAction(String action) throws InvalidInputException {
        if (this.action != null) {
            throw new InvalidInputException(action + " is defined twice!");
        }
        this.action = action;
    }

    public void setHelpFlag() {
        this.helpFlag = true;
    }

    public void appendParameters(String input) {
        this.parameters.add(input);
    }

    public String getCommand() {
        return this.command;
    }

    public String getAction() {
        return this.action;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public boolean getHelpFlag() {
        return this.helpFlag;
    }

    public Map<String, String> getNamedParameters() {
        return this.namedParameters;
    }
}

