/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.Cli;
import com.boom.server.cli.Credentials;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Properties;

public class CliServerConnection {
    private static final String EXIT = "EXIT";
    private Credentials credentials = new Credentials();
    private int cnt_changes = 0;
    private boolean incorrectConnectionPattern = false;
    private String pathForConfigStore = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommandResult connectAndRun(AbstractCommand cmd) throws CommandProcessingException {
        SDataOutputStream os = null;
        SDataInputStream is = null;
        Socket sock = null;
        try {
            Object nextStr;
            sock = new Socket(this.credentials.getHostName(), this.credentials.getPort());
            sock.setSoTimeout(cmd.getTimeoutMilliseconds());
            sock.setSoLinger(true, 1);
            is = new SDataInputStream(sock.getInputStream());
            os = new SDataOutputStream(sock.getOutputStream(), 1);
            String str = is.readUTF();
            String res = "OK";
            if (str.equalsIgnoreCase("login")) {
                os.writeUTF(this.credentials.getUser());
                nextStr = is.readUTF();
                if (!((String)nextStr).equalsIgnoreCase("password")) throw new InvalidInputException("Username/Password incorrect!", -3);
                os.writeUTF(this.credentials.getPasswordEncrypted());
                String response = is.readUTF();
                if (!response.equals("OK")) {
                    throw new InvalidInputException("Username/Password incorrect!", -4);
                }
            } else if (str.equalsIgnoreCase("valid")) {
                res = "valid";
                System.out.println(res);
            }
            nextStr = cmd.executeCommand(is, os);
            return nextStr;
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            if (exceptionMsg != null && !exceptionMsg.isEmpty()) throw new CommandProcessingException(exceptionMsg, e);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(out));
            exceptionMsg = out.toString();
            throw new CommandProcessingException(exceptionMsg, e);
        }
        finally {
            try {
                assert (os != null);
                os.writeUTF(EXIT);
            }
            catch (Throwable throwable) {}
            try {
                assert (os != null);
                os.write(0);
                os.close();
            }
            catch (Throwable throwable) {}
            try {
                assert (is != null);
                is.close();
            }
            catch (Throwable throwable) {}
            try {
                if (sock != null) {
                    sock.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void setByCfg(String cfg) throws InvalidInputException {
        if (this.cnt_changes >= 1) {
            this.incorrectConnectionPattern = true;
            throw new InvalidInputException("Config file should be read. But connection parameters are provided!", -1);
        }
        if (this.pathForConfigStore != null) {
            throw new InvalidInputException("Config cannot be loaded and stored at the same time", -1);
        }
        this.readConfigFile(cfg);
    }

    public void readConfigFile(String cfg) {
        try (FileInputStream fis = new FileInputStream(cfg);){
            Properties p = new Properties();
            p.load(fis);
            String[] val = new String[4];
            String[] fields = new String[]{"Host", "User", "Port", "EnPass"};
            for (int i = 0; i < 4; ++i) {
                val[i] = p.getProperty(fields[i]);
            }
            if (this.hasNoNull(val)) {
                this.credentials.setHostName(val[0]);
                this.credentials.setUser(val[1]);
                this.credentials.setPasswordEncrypted(val[3]);
                this.credentials.setPort(Integer.parseInt(val[2]));
            } else {
                Cli.addMsg("Config file could not be read");
                this.incorrectConnectionPattern = true;
            }
        }
        catch (IOException e) {
            Cli.addMsg("There was a problem with reading the config file.");
        }
    }

    public boolean hasNoNull(String[] input) {
        boolean result = true;
        for (String s : input) {
            if (s != null) continue;
            result = false;
            break;
        }
        return result;
    }

    public void setHost(String host) {
        this.credentials.setHostName(host);
        ++this.cnt_changes;
    }

    public void setPort(int port) {
        this.credentials.setPort(port);
        ++this.cnt_changes;
    }

    public void setUser(String user) {
        this.credentials.setUser(user);
        ++this.cnt_changes;
    }

    public void setPass(String pass) {
        this.credentials.setPassAndEncrypt(pass);
        ++this.cnt_changes;
    }

    public IServerAuth getServerAuth() {
        return this.credentials;
    }

    public void setPathForConfigStore(String pathForConfigStore) {
        this.pathForConfigStore = pathForConfigStore;
    }

    public String getPathForConfigStore() {
        return this.pathForConfigStore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testConnection() throws CommandProcessingException {
        SDataOutputStream os = null;
        SDataInputStream is = null;
        Socket sock = null;
        try {
            sock = new Socket(this.credentials.getHostName(), this.credentials.getPort());
            sock.setSoTimeout(30000);
            sock.setSoLinger(true, 1);
            is = new SDataInputStream(sock.getInputStream());
            os = new SDataOutputStream(sock.getOutputStream(), 1);
            String str = is.readUTF();
            String res = "OK";
            if (str.equalsIgnoreCase("login")) {
                os.writeUTF(this.credentials.getUser());
                String nextStr = is.readUTF();
                if (!nextStr.equalsIgnoreCase("password")) throw new InvalidInputException("Username/Password incorrect!", -3);
                os.writeUTF(this.credentials.getPasswordEncrypted());
                String response = is.readUTF();
                if (!response.equals("OK")) {
                    throw new InvalidInputException("Username/Password incorrect!", -4);
                }
            } else if (str.equalsIgnoreCase("valid")) {
                res = "valid";
                System.out.println(res);
            }
            os.writeUTF(EXIT);
            return true;
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            if (exceptionMsg != null && !exceptionMsg.isEmpty()) throw new CommandProcessingException(exceptionMsg, e);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(out));
            exceptionMsg = out.toString();
            throw new CommandProcessingException(exceptionMsg, e);
        }
        finally {
            try {
                assert (os != null);
                os.write(0);
                os.close();
            }
            catch (Throwable throwable) {}
            try {
                assert (is != null);
                is.close();
            }
            catch (Throwable throwable) {}
            try {
                if (sock != null) {
                    sock.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void storeConfig() throws InvalidInputException, CommandProcessingException {
        if (this.testConnection()) {
            if (this.pathForConfigStore == null) {
                throw new InvalidInputException("Path for the Config file has to be provided");
            }
            try (FileOutputStream fos = new FileOutputStream(this.pathForConfigStore);){
                Properties p = new Properties();
                p.setProperty("Host", this.credentials.getHostName());
                p.setProperty("Port", String.valueOf(this.credentials.getPort()));
                p.setProperty("User", this.credentials.getUser());
                p.setProperty("EnPass", this.credentials.getPasswordEncrypted());
                p.store(fos, "");
                Cli.addMsg("Successfully stored config file.");
            }
            catch (Throwable e) {
                Cli.addMsg("There was an error writing the file");
            }
        }
    }
}

