/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.Cli;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import java.util.List;
import java.util.Map;

public class GeneralHelp
extends AbstractCommand {
    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
    }

    private static String fetchUsage() {
        StringBuilder usage = new StringBuilder("\nboom CLI version: 5.11.0");
        usage.append("\r\nUsage");
        usage.append("\njava -jar boom_cli.jar -h (prints usage)");
        usage.append("\njava -jar boom_cli.jar -version (prints version)");
        usage.append("\njava -jar boom_cli.jar [-s <server>] -u <user> -p <password> -c <command> [-cc <option>] [-a <argument1>] [-a <argument2>] ...");
        usage.append("\njava -jar boom_cli.jar -f <conffile> -c <command> [-cc <option>] [-a <argument1>] [-a <argument2>] ...");
        usage.append("\n\n");
        usage.append("Stores the provided connection parameters in a config file for later usage:\n");
        usage.append("java -jar boom_cli.jar -s <server> -u <user> -p <password> -t <port> -fs <pathToFile>\n");
        usage.append("\n");
        usage.append("For more detailed description type: java -jar boom_cli.jar -h <command>\n");
        usage.append("\n");
        usage.append("Supported commands are: \n");
        ListOfCommands[] lstfcmds = ListOfCommands.values();
        int lineCnt = 1;
        for (ListOfCommands entry : lstfcmds) {
            if (lineCnt < entry.getSeparatorHelpOutput()) {
                usage.append("\n");
                ++lineCnt;
            }
            if (!entry.isPrintShortUsage()) continue;
            Object command = entry.getCmdCommand();
            for (int i = ((String)command).length(); i < 30; ++i) {
                command = (String)command + " ";
            }
            usage.append((String)command).append(entry.getDescription()).append("\n");
        }
        return usage.toString();
    }

    public static String getGeneralHelp() {
        return GeneralHelp.fetchUsage();
    }

    @Override
    public String getUsage() {
        String usage = GeneralHelp.fetchUsage();
        Cli.addMsg("general help");
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) {
        String usage = GeneralHelp.fetchUsage();
        Cli.addMsg("general help");
        return new CommandResult(usage);
    }
}

