/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Action
extends AbstractCommand {
    public static final String COMMAND = "ACTION";

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) throws InvalidInputException {
        this.command = command;
        this.action = action;
        this.params = params;
        if (action == null || action.length() < 1) {
            throw new InvalidInputException("No action was parsed!");
        }
        if (params == null || params.size() < 2) {
            throw new InvalidInputException("Exactly 2 parameters have to be parsed!");
        }
        try {
            this.timeoutMilliseconds = Integer.parseInt(params.get(1)) * 1000;
        }
        catch (NumberFormatException e) {
            throw new InvalidInputException("The second argument could not be parsed to a number.");
        }
    }

    @Override
    public String getUsage() {
        Object usage = "ACTION\n";
        usage = (String)usage + "\tjava -jar boom_cli.jar -f <conffile> -c ACTION -cc <action> -a <agentID> -a <timeoutSec>\n";
        usage = (String)usage + "\tDESCRIPTION\t" + ListOfCommands.ACTION.getDescription() + "\n";
        usage = (String)usage + "\tOPTION -cc\t\"Remote agent or server action\"\n";
        usage = (String)usage + "\tARGUMENTS -a\tPair of 2 required arguments:\n";
        usage = (String)usage + "\t\t\tagentID - one or more agent IDs separated by comma\n";
        usage = (String)usage + "\t\t\ttimeout - in seconds\n";
        usage = (String)usage + "\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c ACTION -cc \"BOOM_AGENT STATUS\" -a 6ff38d81-9e79-4cb6-9571-a7e2622f3297 -a 120\n";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        StringBuilder tmpMsg = new StringBuilder();
        int timeout = 600;
        try {
            timeout = Integer.parseInt((String)this.params.get(1));
        }
        catch (Exception e1) {
            throw new CommandProcessingException("Unparsable timeout: " + (String)this.params.get(1));
        }
        os.writeUTF(this.command);
        os.writeUTF(UUID.randomUUID().toString());
        os.writeUTF(this.action);
        os.writeUTF((String)this.params.get(0));
        os.writeInt(timeout);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ignored) {
            return null;
        }
        String text = is.readUTF();
        String okay = is.readUTF();
        if (!okay.equals("T")) {
            throw new CommandProcessingException("Error running Action " + this.action);
        }
        tmpMsg.append("Action finished. ").append(this.action).append("\n");
        tmpMsg.append(text);
        return new CommandResult(tmpMsg.toString());
    }
}

