/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds;

import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.Action;
import com.boom.server.cli.cmds.GetOnlineUsers;
import com.boom.server.cli.cmds.SendMessage;
import com.boom.server.cli.cmds.agt.ApproveAgents;
import com.boom.server.cli.cmds.agt.CreateAgent;
import com.boom.server.cli.cmds.agt.DeleteAgent;
import com.boom.server.cli.cmds.agt.DisableAgent;
import com.boom.server.cli.cmds.agt.EnableAgent;
import com.boom.server.cli.cmds.agt.GetAgentCards;
import com.boom.server.cli.cmds.agt.GetAgentCardsAll;
import com.boom.server.cli.cmds.agt.GetAgentCardsExt;
import com.boom.server.cli.cmds.agt.GetAgentId;
import com.boom.server.cli.cmds.agt.GetAgentStatus;
import com.boom.server.cli.cmds.agt.LinkAgentToNodeGroup;
import com.boom.server.cli.cmds.agt.MirrorAgents;
import com.boom.server.cli.cmds.agt.SetAgentAttribute;
import com.boom.server.cli.cmds.agt.UnLinkAgentToNodeGroup;
import com.boom.server.cli.cmds.deploy.Deploy;
import com.boom.server.cli.cmds.deploy.DeployIfNotDeployed;
import com.boom.server.cli.cmds.deploy.MarkAsDeployed;
import com.boom.server.cli.cmds.deploy.PushPackage;
import com.boom.server.cli.cmds.deploy.Undeploy;
import com.boom.server.cli.cmds.deploy.UndeployDelayed;
import com.boom.server.cli.cmds.file.CreateFile;
import com.boom.server.cli.cmds.file.DeleteFile;
import com.boom.server.cli.cmds.file.DeleteFolder;
import com.boom.server.cli.cmds.file.GetFileFromAgent;
import com.boom.server.cli.cmds.file.PutFile;
import com.boom.server.cli.cmds.file.PutFileOnAgent;
import com.boom.server.cli.cmds.indi.AddIndicationAnnotation;
import com.boom.server.cli.cmds.indi.AddIndicationAnnotationFromFile;
import com.boom.server.cli.cmds.indi.ArchiveIndication;
import com.boom.server.cli.cmds.indi.CloseIndication;
import com.boom.server.cli.cmds.indi.DeleteIndication;
import com.boom.server.cli.cmds.indi.DisownIndication;
import com.boom.server.cli.cmds.indi.OwnIndication;
import com.boom.server.cli.cmds.indi.SetIndicationCustomAttribute;
import com.boom.server.cli.cmds.indi.SubmitIndication;
import com.boom.server.cli.cmds.nodegroup.CreateNodeGroup;
import com.boom.server.cli.cmds.nodegroup.DeleteNodeGroup;
import com.boom.server.cli.cmds.nodegroup.GetAgentIDs4NG;
import com.boom.server.cli.cmds.nodegroup.GetAgentNodeGroups;
import com.boom.server.cli.cmds.nodegroup.GetNodeGroups;
import com.boom.server.cli.cmds.nodegroup.RenameNodeGroup;
import com.boom.server.cli.cmds.pkg.CreatePackage;
import com.boom.server.cli.cmds.pkg.GetAllAssignments;
import com.boom.server.cli.cmds.pkg.ListPackages;
import com.boom.server.cli.cmds.pol.ExportPolicies;
import com.boom.server.cli.cmds.pol.GetAgentPolicies;
import com.boom.server.cli.cmds.pol.GetPolicies;
import com.boom.server.cli.cmds.pol.ImportPolicies;
import java.util.function.Supplier;

public enum ListOfCommands {
    ACTION("ACTION", "Runs a remote action on agent or server", true, 1, Action::new),
    ADD_ANNOTATION("ADD_ANNOTATION", "Adds an annotation to a specified indication", true, 1, AddIndicationAnnotation::new),
    ADD_ANNOTATION_FROM_FILE("ADD_ANNOTATION_FROM_FILE", "Adds a file content as annotation to an indication", true, 1, AddIndicationAnnotationFromFile::new),
    APPROVE_AGENT("APPROVE_AGENT", "Approves an agent", true, 1, ApproveAgents::new),
    ARCH_INDI("ARCH_INDI", "Archives indications", true, 1, ArchiveIndication::new),
    ARCH_MSG("ARCH_MSG", "Archives indications", false, 1, ArchiveIndication::new),
    BOOM_AGENT_GETFILE("BOOM_AGENT_GETFILE", "Gets a file from an agent", true, 2, GetFileFromAgent::new),
    BOOM_AGENT_PUTFILE("BOOM_AGENT_PUTFILE", "Puts a file to an agent", true, 2, PutFileOnAgent::new),
    CLOSE_INDI("CLOSE_INDI", "Closes indications", true, 3, CloseIndication::new),
    CLOSE_MSG("CLOSE_MSG", "Closes indications", false, 3, CloseIndication::new),
    CMD_DISOWN("CMD_DISOWN", "Disown indications", true, 3, DisownIndication::new),
    CMD_OWN("CMD_OWN", "Marks indications as owned", true, 3, OwnIndication::new),
    CREATE_AGENT("CREATE_AGENT", "Creates an agent", true, 3, CreateAgent::new),
    CREATE_FILE("CREATE_FILE", "Uploads a new file in specified binary package on the server", true, 3, CreateFile::new),
    CREATE_NODEGROUP("CREATE_NODEGROUP", "Creates a node group", true, 3, CreateNodeGroup::new),
    CREATE_PACKAGE("CREATE_PACKAGE", "Creates a binary package", true, 3, CreatePackage::new),
    DELETE_AGENT("DELETE_AGENT", "Deletes an agent", true, 4, DeleteAgent::new),
    DELETEAGENT("DELETEAGENT", "Deletes an agent", false, 4, DeleteAgent::new),
    DELETE_FILE("DELETE_FILE", "Deletes a file in specified binary package on the server", true, 4, DeleteFile::new),
    DELETE_FOLDER("DELETE_FOLDER", "Deletes a folder in specified binary package on the server", true, 4, DeleteFolder::new),
    DELETE_INDI("DELETE_INDI", "Deletes indications", true, 4, DeleteIndication::new),
    DELETE_MSG("DELETE_MSG", "Deletes indications", false, 4, DeleteIndication::new),
    DELETE_NODEGROUP("DELETE_NODEGROUP", "Deletes a node group", true, 4, DeleteNodeGroup::new),
    DEPLOY("DEPLOY", "Deploys a policy, binary package or assignment group to specified agent", true, 4, Deploy::new),
    DEPLOY_IF_NOTDEPLOYED("DEPLOY_IF_NOTDEPLOYED", "Deploys a policy, binary package or assignment group to specified agent, if not deployed", true, 4, DeployIfNotDeployed::new),
    DISABLE_AGENT("DISABLE_AGENT", "Disables an agent", true, 4, DisableAgent::new),
    ENABLE_AGENT("ENABLE_AGENT", "Enables an agent", true, 5, EnableAgent::new),
    EXPORT_POLICIES("EXPORT_POLICIES", "Exports policies to .xml format", true, 5, ExportPolicies::new),
    GETAGENTCARDS("GETAGENTCARDS", "Prints agent cards", true, 6, GetAgentCards::new),
    GETAGENTCARDSALL("GETAGENTCARDSALL", "Prints agent cards of agents and virtual agents", true, 6, GetAgentCardsAll::new),
    GETAGENTCARDSEXT("GETAGENTCARDSEXT", "Prints virtual agent cards", true, 6, GetAgentCardsExt::new),
    GETAGENTID("GETAGENTID", "Lookup an agent ID by specified hostname", true, 6, GetAgentId::new),
    GETAGENTIDS4NG("GETAGENTIDS4NG", "Prints a list of agent IDs for specified node group path (non-recursive)", true, 6, GetAgentIDs4NG::new),
    GETAGENTNODEGROUPS("GETAGENTNODEGROUPS", "Prints a list of node groups where specified agent is linked", true, 6, GetAgentNodeGroups::new),
    GET_AGENT_POLICIES("GET_AGENT_POLICIES", "Prints a list of deployed policies for specified agent", true, 6, GetAgentPolicies::new),
    GET_AGENTS_STATUS("GET_AGENTS_STATUS", "Prints agents statuses", true, 6, GetAgentStatus::new),
    GET_ALL_ASSIGNMENTS("GET_ALL_ASSIGNMENTS", "Returns assignments", true, 6, GetAllAssignments::new),
    GETNODEGROUPS("GETNODEGROUPS", "Prints node groups available on the server", true, 6, GetNodeGroups::new),
    GET_ONLINE_USERS("GET_ONLINE_USERS", "Prints list of online users", true, 6, GetOnlineUsers::new),
    GETPOLICIES("GETPOLICIES", "Prints a list of policies available on the server", true, 6, GetPolicies::new),
    IMPORT_POLICIES("IMPORT_POLICIES", "Imports policies in .xml format", true, 7, ImportPolicies::new),
    LINK_AGENT("LINK_AGENT", "Links agents to a node group", true, 8, LinkAgentToNodeGroup::new),
    LIST_PACKAGES("LIST_PACKAGES", "Lists binary packages", true, 8, ListPackages::new),
    MARK_AS_DEPLOYED("MARK_AS_DEPLOYED", "Marks a policy, binary package or assignment group as deployed on a specified agent", true, 9, MarkAsDeployed::new),
    MIRROR_AGENT("MIRROR_AGENT", "Mirrors an agent", false, 9, MirrorAgents::new),
    PUSH_PACKAGE("PUSH_PACKAGE", "Uploads binary packages to all proxy slave servers", true, 10, PushPackage::new),
    PUT_FILE("PUT_FILE", "Uploads and replaces a file in a specified binary package on the server", true, 10, PutFile::new),
    RENAME_NODEGROUP("RENAME_NODEGROUP", "Renames a node group", true, 11, RenameNodeGroup::new),
    SEND_MESSAGE("SEND_MESSAGE", "Sends messages to users", true, 12, SendMessage::new),
    SET_AGENT_ATTR("SET_AGENT_ATTR", "Sets custom attribute values of an agent", true, 12, SetAgentAttribute::new),
    SET_CA("SET_CA", "Sets custom attribute of a specified indication", true, 12, SetIndicationCustomAttribute::new),
    SUBMIT_INDI("SUBMIT_INDI", "Submits an indication. Only for test purposes", false, 12, SubmitIndication::new),
    UNDEPLOY("UNDEPLOY", "Undeploys a policy, binary package or assignment group from specified agent", true, 13, Undeploy::new),
    UNDEPLOY_DELAYED("UNDEPLOY_DELAYED", "Undeploys a package with delay", false, 13, UndeployDelayed::new),
    UNLINK_AGENT("UNLINK_AGENT", "Unlinks agents from a node group", true, 13, UnLinkAgentToNodeGroup::new);

    private final String cmdCommand;
    private final String description;
    private final boolean printShortUsage;
    private final int separatorHelpOutput;
    private final Supplier<AbstractCommand> commandInstanceCreator;

    public int getSeparatorHelpOutput() {
        return this.separatorHelpOutput;
    }

    private ListOfCommands(String cmdCommand, String description, boolean printShortUsage, int separatorHelpOutput, Supplier<AbstractCommand> commandInstanceCreator) {
        this.cmdCommand = cmdCommand;
        this.description = description;
        this.printShortUsage = printShortUsage;
        this.separatorHelpOutput = separatorHelpOutput;
        this.commandInstanceCreator = commandInstanceCreator;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPrintShortUsage() {
        return this.printShortUsage;
    }

    public Supplier<AbstractCommand> getCommandInstanceCreator() {
        return this.commandInstanceCreator;
    }

    public String getCmdCommand() {
        return this.cmdCommand;
    }
}

