/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.agt;

import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.CliCommandFactory;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.nodegroup.NodeGroupUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import com.boom.server.cli.exceptions.UnknownCommandException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;

public abstract class AbstractEnableDisable
extends AbstractCommand {
    protected String cmdParse;

    private String specialActionCmd(SDataInputStream is, SDataOutputStream os, String param) throws IOException {
        String outTxt = this.cmdParse.contains("ENABLE") ? "enabled" : "disabled";
        os.writeUTF("ACTION");
        os.writeUTF(UUID.randomUUID().toString());
        os.writeUTF(this.cmdParse);
        os.writeUTF(param);
        os.writeInt(1);
        String text = is.readUTF();
        String isOk = is.readUTF();
        if (isOk.equals("T")) {
            return "Agent " + param + " was " + outTxt + "\n";
        }
        return "Agent " + param + " couldn't be " + outTxt + "\n";
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        StringBuilder tmpMsg = new StringBuilder();
        if (this.action == null) {
            throw new UnknownActionException("No action was parsed!", null);
        }
        if (this.params.isEmpty()) {
            throw new ParameterUsageException("Missing Parameters", this.params);
        }
        switch (this.action) {
            case "agtid": {
                for (String param : this.params) {
                    CliCommandFactory fact = new CliCommandFactory();
                    try {
                        CommandResult paramtmp = fact.getCommand("GETAGENTCARDSALL", "agtid", Collections.singletonList(param), null, "\t", null).executeCommand(is, os);
                        if (!paramtmp.getOutput().startsWith(param)) {
                            tmpMsg.append(paramtmp.getOutput());
                            continue;
                        }
                        tmpMsg.append(this.specialActionCmd(is, os, param));
                    }
                    catch (UnknownCommandException e) {
                        throw new CommandProcessingException(e.getMessage(), e);
                    }
                    catch (IOException e) {
                        throw new CommandProcessingException("An error with the server communication occured.", e);
                    }
                }
                break;
            }
            case "agtname": {
                try {
                    Iterator iterator = this.params.iterator();
                    while (iterator.hasNext()) {
                        CliCommandFactory fact = new CliCommandFactory();
                        String param = (String)iterator.next();
                        CommandResult paramtmp = fact.getCommand("GETAGENTID", param, Collections.emptyList(), null, "\t", null).executeCommand(is, os);
                        if (paramtmp.getOutput().contains("could not be found")) {
                            tmpMsg.append(paramtmp.getOutput());
                            continue;
                        }
                        tmpMsg.append(this.specialActionCmd(is, os, paramtmp.getOutput()));
                    }
                    break;
                }
                catch (IOException e) {
                    throw new CommandProcessingException("An error with the server communication occured.", e);
                }
                catch (UnknownCommandException e) {
                    throw new CommandProcessingException(e.getMessage(), e);
                }
            }
            case "agtpath": {
                CliCommandFactory fact = new CliCommandFactory();
                try {
                    for (String param : this.params) {
                        CommandResult paramtmp = fact.getCommand("GETAGENTCARDSALL", "agtid", Collections.singletonList(param = NodeGroupUtils.extractAgentIdFromAgentPath(param)), null, "\t", null).executeCommand(is, os);
                        if (!paramtmp.getOutput().startsWith(param)) {
                            tmpMsg.append(paramtmp.getOutput());
                            continue;
                        }
                        tmpMsg.append(this.specialActionCmd(is, os, param));
                    }
                    break;
                }
                catch (IOException e) {
                    throw new CommandProcessingException("An error with the server communication occured.", e);
                }
                catch (UnknownCommandException e) {
                    throw new CommandProcessingException(e.getMessage(), e);
                }
            }
            default: {
                throw new UnknownActionException("Unknown action was parsed!", this.action);
            }
        }
        return new CommandResult(tmpMsg.toString());
    }
}

