/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.agt;

import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.XMLTree;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.agt.AgentCardCmdUtils;
import com.boom.server.cli.cmds.nodegroup.NodeGroupUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public abstract class AbstractGetAgentCards
extends AbstractCommand {
    protected boolean fetchReal;
    protected boolean fetchExternal;
    protected String separator;

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, ParameterUsageException, CommandProcessingException {
        StringBuilder tmpMsg = new StringBuilder();
        try {
            if (this.action == null) {
                this.action = "";
            }
            if (this.params.isEmpty() && !this.action.equals("") && !this.action.equals("ungrouped")) {
                throw new ParameterUsageException("Missing Parameters", this.params);
            }
            Map<String, AbstractAgentCard> agentCards = AgentCardCmdUtils.splitExternalAgents(AgentCardCmdUtils.collectAgentCards(is, os), this.fetchReal, this.fetchExternal);
            String xmlAsString = NodeGroupUtils.getXml(is, os);
            GroupTreeObject nodeGroupTree = new XMLTree().parseXML(new ByteArrayInputStream(xmlAsString.getBytes()), true);
            switch (this.action) {
                case "ngname": {
                    TreeSet<AbstractAgentCard> distinctAgents = new TreeSet<AbstractAgentCard>(Comparator.comparing(AbstractAgentCard::getLabel));
                    for (GroupTreeObjectLast gto : nodeGroupTree.getAllGTOLs()) {
                        for (String ngname : this.params) {
                            String agentId;
                            AbstractAgentCard abstractAgentCard;
                            String agtPath = gto.getPath();
                            if (!agtPath.substring("/root/_Groups".length()).contains("/" + ngname + "/") || (abstractAgentCard = agentCards.get(agentId = agtPath.substring(agtPath.lastIndexOf(47) + 1))) == null) continue;
                            distinctAgents.add(abstractAgentCard);
                        }
                    }
                    distinctAgents.forEach(ac -> tmpMsg.append(ac).append("\n"));
                    break;
                }
                case "ngpath": {
                    TreeSet<AbstractAgentCard> distinctAgents2 = new TreeSet<AbstractAgentCard>(Comparator.comparing(AbstractAgentCard::getLabel));
                    List<String> tmpParams = this.params.stream().map(NodeGroupUtils::normalizePath).toList();
                    for (String path : tmpParams) {
                        GroupTreeObject ngr = nodeGroupTree.searchPath(path, "");
                        if (ngr == null) {
                            throw new CommandProcessingException("NodeGroup not found: " + path);
                        }
                        ngr.getAllGTOLs().forEach(acGtol -> {
                            String agentId = acGtol.getPath().replaceAll("/.*/", "");
                            AbstractAgentCard abstractAgentCard = (AbstractAgentCard)agentCards.get(agentId);
                            if (abstractAgentCard != null) {
                                distinctAgents2.add(abstractAgentCard);
                            }
                        });
                    }
                    distinctAgents2.forEach(ac -> tmpMsg.append(ac).append("\n"));
                    break;
                }
                case "ngname-all": {
                    for (GroupTreeObjectLast gto : nodeGroupTree.getAllGTOLs()) {
                        for (String ngname : this.params) {
                            String agentId;
                            AbstractAgentCard abstractAgentCard;
                            String agtPath = gto.getPath();
                            if (!agtPath.substring("/root/_Groups".length()).contains("/" + ngname + "/") || (abstractAgentCard = agentCards.get(agentId = agtPath.substring(agtPath.lastIndexOf(47) + 1))) == null) continue;
                            tmpMsg.append(abstractAgentCard).append(this.separator).append(gto.getPath()).append("\n");
                        }
                    }
                    break;
                }
                case "ngpath-all": {
                    List<String> tmpParams2 = this.params.stream().map(NodeGroupUtils::normalizePath).toList();
                    for (String path : tmpParams2) {
                        GroupTreeObject ngr = nodeGroupTree.searchPath(path, "");
                        if (ngr == null) {
                            throw new CommandProcessingException("NodeGroup not found: " + path);
                        }
                        ngr.getAllGTOLs().forEach(acGtol -> {
                            String agentId = acGtol.getPath().replaceAll("/.*/", "");
                            AbstractAgentCard abstractAgentCard = (AbstractAgentCard)agentCards.get(agentId);
                            if (abstractAgentCard != null) {
                                tmpMsg.append(abstractAgentCard).append(this.separator).append(acGtol.getParent().getPath()).append("\n");
                            }
                        });
                    }
                    break;
                }
                case "agtid": {
                    for (String agentId : this.params) {
                        if (agentCards.containsKey(agentId)) {
                            AbstractAgentCard abstractAgentCard = agentCards.get(agentId);
                            if (abstractAgentCard == null) continue;
                            tmpMsg.append(abstractAgentCard).append("\n");
                            continue;
                        }
                        tmpMsg.append("Agent not found. ID: ").append(agentId);
                    }
                    break;
                }
                case "ungrouped": {
                    agentCards.values().stream().filter(ac -> nodeGroupTree.findElement(ac.getAgentID(), "agt") == null).forEach(ac -> tmpMsg.append(ac).append("\n"));
                    break;
                }
                case "": {
                    agentCards.values().forEach(ac -> tmpMsg.append(ac).append("\n"));
                    break;
                }
                default: {
                    throw new UnknownActionException("Unknown action was parsed!", this.action);
                }
            }
        }
        catch (IOException | IllegalAccessException | InstantiationException | NullPointerException e) {
            throw new CommandProcessingException("An internal problem when running the command occurred.", e);
        }
        catch (ParameterUsageException e) {
            throw new ParameterUsageException(e.getMessage());
        }
        return new CommandResult(tmpMsg.toString());
    }
}

