/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.agt;

import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.StrUtils;
import com.boom.server.cli.CliCommandFactory;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.agt.AgentCardLite;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import com.boom.server.cli.exceptions.UnknownCommandException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AgentCardCmdUtils {
    private static final StrUtils strUtils = new StrUtils();

    private AgentCardCmdUtils() {
    }

    public static List<String> fetchAgentIDbyName(SDataInputStream is, SDataOutputStream os, List<String> list) throws ParameterUsageException, CommandProcessingException, UnknownActionException {
        ArrayList<String> tmpList = new ArrayList<String>();
        try {
            CliCommandFactory fact = new CliCommandFactory();
            for (String agentName : list) {
                String tmpres = fact.getCommand("GETAGENTID", agentName, Collections.emptyList(), null, "\t", null).executeCommand(is, os).getOutput();
                if (tmpres.contains("could not be found")) {
                    throw new CommandProcessingException("Agent name " + agentName + " could not be converted to agentID.");
                }
                tmpList.add(tmpres);
            }
        }
        catch (InvalidInputException | UnknownCommandException | IOException e) {
            throw new CommandProcessingException(e.getMessage(), e);
        }
        return tmpList;
    }

    public static Map<String, AbstractAgentCard> collectAgentCards(SDataInputStream is, SDataOutputStream os) throws IOException, IllegalAccessException, InstantiationException, CommandProcessingException {
        HashMap<String, AbstractAgentCard> collectedAgentCards = new HashMap<String, AbstractAgentCard>();
        os.writeUTF("GETAGENTCARDS");
        int numberOfEntries = is.readInt();
        if (numberOfEntries == 0) {
            throw new CommandProcessingException("No AgentCards found on the server!", -16);
        }
        for (int i = 0; i < numberOfEntries; ++i) {
            AbstractAgentCard ac = (AbstractAgentCard)AgentCardLite.class.newInstance();
            ac.read(is);
            collectedAgentCards.put(ac.getID(), ac);
        }
        if (is.readUTF().equals("T")) {
            return collectedAgentCards;
        }
        throw new IOException("A problem occurred during fetching of agent cards from server!");
    }

    public static Map<String, AbstractAgentCard> splitExternalAgents(Map<String, AbstractAgentCard> collAgtCrds, boolean fetchReal, boolean fetchExternal) {
        HashMap<String, AbstractAgentCard> resMap = new HashMap<String, AbstractAgentCard>();
        for (AbstractAgentCard agtCrd : collAgtCrds.values()) {
            boolean external = AgentCardCmdUtils.isExternal(agtCrd);
            if (fetchExternal && external) {
                resMap.put(agtCrd.getAgentID(), agtCrd);
                continue;
            }
            if (!fetchReal || external) continue;
            resMap.put(agtCrd.getAgentID(), agtCrd);
        }
        return resMap;
    }

    public static boolean isExternal(AbstractAgentCard agentCard) {
        return agentCard.getAgentPort() == 0;
    }

    public static CommandResult getAgentsByID(Map<String, AbstractAgentCard> agents, String[] ids, SDataInputStream is, SDataOutputStream os) {
        if (ids == null || ids.length == 0) {
            return new CommandResult("Incorrect parameters!", -1);
        }
        int res = 0;
        StringBuilder output = new StringBuilder();
        if (agents.isEmpty()) {
            return new CommandResult("No AgentCards found on the server!", -16);
        }
        int notFound = 0;
        List<String> idList = Arrays.asList(ids);
        for (String agentID : idList) {
            if (agents.containsKey(agentID = strUtils.removeQuotes(agentID))) {
                AbstractAgentCard acl = agents.get(agentID);
                output.append(agentID).append(" ").append(acl.getAgentHost());
                continue;
            }
            output.append("Invalid ID: ").append(agentID);
            ++notFound;
        }
        if (notFound > 0) {
            res = 1;
        }
        return new CommandResult(output.toString(), res);
    }
}

