/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.agt;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.in.ScJobApproveAgents;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.agt.AgentCardCmdUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ApproveAgents
extends AbstractCommand {
    public static final String CMD_APPROVE_AGENTS = "APPROVE_AGENT";
    public static final String COMMAND = "APPROVE_AGENT";
    private IServerAuth auth;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.auth = auth;
    }

    @Override
    public String getUsage() {
        Object output = "\nAPPROVE_AGENT";
        output = (String)output + "\n\tjava -jar boom_cli.jar -f <conffile> -c APPROVE_AGENT -a <id> -a <id> ... ";
        output = (String)output + "\n\tDESCRIPTION\t" + ListOfCommands.APPROVE_AGENT.getDescription();
        output = (String)output + "\n\tCOMMAND -c\t\"APPROVE_AGENT\"";
        output = (String)output + "\n\tARGUMENTS -a\t\"AgentID\" -a\t\"AgentID\" ... (at least one line is required)";
        output = (String)output + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c APPROVE_AGENT -a \"125a4152-6928-4846-9e20-8ded4230589b\"";
        return output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        StringBuilder output = new StringBuilder();
        if (this.action != null) {
            throw new UnknownActionException("Unrequired action was parsed!", this.action);
        }
        if (this.params == null || this.params.isEmpty()) throw new ParameterUsageException("Missing Parameters");
        try {
            Map<String, AbstractAgentCard> collectedAgentCards = AgentCardCmdUtils.collectAgentCards(is, os);
            ArrayList<String> agents = new ArrayList<String>(this.params.size());
            for (String id : this.params) {
                AbstractAgentCard ac = collectedAgentCards.get(id);
                if (ac != null) {
                    ac.setApproved();
                    agents.add(ac.getAgentID());
                    continue;
                }
                output.append("[WARNING] AgentCard not found. ID: ").append(id).append("\n");
            }
            if (!agents.isEmpty()) {
                ScJobApproveAgents sc = new ScJobApproveAgents(this.auth, this.params.toArray(new String[0]));
                sc.runDirect(is, os);
                if (!sc.isSuccess()) return new CommandResult(output.toString());
                output.append(agents.size()).append(" Agents approved.\n");
                return new CommandResult(output.toString());
            } else {
                output.append("No Agents found with given IDs.\n");
            }
            return new CommandResult(output.toString());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CommandProcessingException("An internal problem when running the command occurred.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new CommandResult("Command execution has been interrupted", -99);
        }
    }
}

