/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.agt;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.agt.CreateAgentRcpUi;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CreateAgent
extends AbstractCommand {
    public static final String T = "T";
    public static final String CMD_JOB = "JOB";
    public static final String JOB_CREATE_AGENT = "JOB_CREATE_AGENT";
    public static final String HOST = "host";
    public static final String AGENT_IP = "agent_ip";
    public static final String ENABLED = "enabled";
    public static final String PORT = "port";
    public static final String APPROVED = "approved";
    public static final String FIREWALLED = "firewalled";
    public static final String SLAVE_SERVER = "slave_server";
    public static final String AGENT_ID = "agent_id";
    public static final String LABEL = "label";
    public static final String TLS = "tls";
    private Map<String, String> namedParameters;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.namedParameters = namedParameters;
    }

    @Override
    public String getUsage() {
        Object usage = this.getCommand();
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c " + this.getCommand() + " --host hostname [--agent_ip agentip] [--agent_id agentID] [--label label] [--port port] [--approved true|false] [--firewalled true|false] [--tls true|false] [--slave_server slave]";
        usage = (String)usage + "\n" + this.getCommand();
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.CREATE_AGENT.getDescription();
        usage = (String)usage + "\n\t\teither --agent_ip or --host has to be defined!";
        usage = (String)usage + "\n\t\tdefault values: port==0, approved=true, firewalled=false, tls=true";
        usage = (String)usage + "\n\tCOMMAND -c\t\"" + this.getCommand() + "\"";
        usage = (String)usage + "\n\tARGUMENTS";
        usage = (String)usage + "\n\t\t--host - hostname (Required)";
        usage = (String)usage + "\n\t\t--agent_ip - IP address";
        usage = (String)usage + "\n\t\t--agent_id - globally unique Agent ID (will be generated automatically if not set)";
        usage = (String)usage + "\n\t\t--label - agent label (will be set to hostname if not specified )";
        usage = (String)usage + "\n\t\t--port - agent port (for Virtual Agents must be '0')";
        usage = (String)usage + "\n\t\t--approved - true|false";
        usage = (String)usage + "\n\t\t--firewalled - true|false";
        usage = (String)usage + "\n\t\t--tls - true|false";
        usage = (String)usage + "\n\t\t--slave_server - Slave server name as known by master server";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c " + this.getCommand() + " --host hostname.domain.net --agent_ip 10.1.1.25 --port 23031 --approved true --firewalled false";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws InvalidInputException {
        Object result;
        try {
            os.writeUTF(CMD_JOB);
            os.writeUTF(JOB_CREATE_AGENT);
            os.writeInt(1);
            CreateAgentRcpUi payload = this.getCreateAgentJson();
            os.writeUTF(new GsonBuilder().create().toJson(payload));
            String output = is.readUTF();
            result = T.equals(output) ? "Agent created. ID: " + payload.id : output;
        }
        catch (IOException e) {
            result = e.getMessage();
        }
        return new CommandResult((String)result);
    }

    public CreateAgentRcpUi getCreateAgentJson() throws InvalidInputException {
        int port;
        String agentIP = this.namedParameters.get(AGENT_IP);
        String portStr = this.namedParameters.get(PORT);
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            throw new InvalidInputException("Could not parse port value: " + portStr);
        }
        boolean tls = "true".equalsIgnoreCase(this.namedParameters.getOrDefault(TLS, "true"));
        CreateAgentRcpUi payload = new CreateAgentRcpUi(agentIP, port, tls);
        String agentId = this.namedParameters.get(AGENT_ID);
        payload.id = this.isEmpty(agentId) ? UUID.randomUUID().toString() : agentId;
        payload.label = this.namedParameters.get(LABEL);
        payload.host = this.namedParameters.get(HOST);
        payload.slaveServer = this.namedParameters.get(SLAVE_SERVER);
        String appr = this.namedParameters.get(APPROVED);
        payload.approved = !"false".equalsIgnoreCase(appr);
        String fw = this.namedParameters.get(FIREWALLED);
        payload.firewalled = "true".equalsIgnoreCase(fw);
        return payload;
    }

    private boolean isEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }
}

