/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.agt;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.agt.AgentCardCmdUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GetAgentStatus
extends AbstractCommand {
    public static final String COMMAND = "GET_AGENTS_STATUS";

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
    }

    public String agentIDtoStatus(AbstractAgentCard collectedAgentCard) {
        StringBuilder tmpMsg = new StringBuilder();
        if (collectedAgentCard.getAgentPort() != 0) {
            tmpMsg.append(collectedAgentCard.getAgentID()).append(' ').append(collectedAgentCard.getAgentHost()).append(' ');
            tmpMsg.append(collectedAgentCard.getAgentIP() == null ? "null" : collectedAgentCard.getAgentIP()).append(' ');
            tmpMsg.append(collectedAgentCard.isApproved() ? "approved" : "not_approved");
            tmpMsg.append(' ').append(collectedAgentCard.isDisabled() ? "disabled" : "enabled");
            tmpMsg.append(' ').append(collectedAgentCard.isFirewalled() ? "firewalled" : "not_firewalled");
            tmpMsg.append(' ').append(collectedAgentCard.isOnline() ? "online" : "offline").append("\n");
        } else {
            tmpMsg.append(collectedAgentCard.getAgentID()).append(' ').append(collectedAgentCard.getAgentHost()).append(' ').append(collectedAgentCard.getAgentIP() == null ? "null" : collectedAgentCard.getAgentIP()).append(' ').append(collectedAgentCard.isApproved() ? "approved" : "not_approved").append(' ').append(collectedAgentCard.isDisabled() ? "disabled" : "enabled").append(" EXTERNAL").append("\n");
        }
        return tmpMsg.toString().trim();
    }

    @Override
    public String getUsage() {
        Object usage = COMMAND;
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c GET_AGENTS_STATUS [-cc ngname [-a \"NodeGroup name1\"] [-a \"NodeGroup name2\"]...]";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.GET_AGENTS_STATUS.getDescription();
        usage = (String)usage + "\n\t\t\tAgent_ID\thostname\tIP\tapproved\tenabled\tfirewalled\tonline";
        usage = (String)usage + "\n\tCOMMAND -c\t\"GET_AGENTS_STATUS\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"agtname\"|\"agtid\"|\"all\"|\"internal\"|\"external\" (Default all)";
        usage = (String)usage + "\n\tARGUMENTS -a\t\"agent name\"|\"agentid\" (depends on option specified)";
        usage = (String)usage + "\n\tEXAMPLES\tList all agent statuses. ";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GET_AGENTS_STATUS -cc all | or no option";
        usage = (String)usage + "\n\t\t\tList agent status for all internal agents:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GET_AGENTS_STATUS -cc internal";
        usage = (String)usage + "\n\t\t\tList agent status for all external agents:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GET_AGENTS_STATUS -cc external";
        usage = (String)usage + "\n\t\t\tList agent status for the specified agent names:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GET_AGENTS_STATUS -cc agtname -a agent1 -a agent2";
        usage = (String)usage + "\n\t\t\tList agent status for the specified AgentIDs:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GET_AGENTS_STATUS -cc agtid -a 6ff38d81-9e79-4cb6-9571-a7e2622f3297 -a 8lk38d81-9e79-c5b6-9571-a7e4892f3034";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, ParameterUsageException, CommandProcessingException {
        StringBuilder tmpMsg = new StringBuilder();
        String string = this.action = this.action == null ? "" : this.action;
        if (!this.params.isEmpty() && this.action.equals("")) {
            throw new ParameterUsageException("No parameter should have been parsed for this command.");
        }
        try {
            Map<String, AbstractAgentCard> collectedAgentCards;
            switch (this.action) {
                case "agtname": {
                    this.params = AgentCardCmdUtils.fetchAgentIDbyName(is, os, this.params);
                }
                case "": 
                case "all": 
                case "agtid": {
                    collectedAgentCards = AgentCardCmdUtils.splitExternalAgents(AgentCardCmdUtils.collectAgentCards(is, os), true, true);
                    break;
                }
                case "external": {
                    if (this.params.isEmpty()) {
                        collectedAgentCards = AgentCardCmdUtils.splitExternalAgents(AgentCardCmdUtils.collectAgentCards(is, os), false, true);
                        break;
                    }
                    throw new ParameterUsageException("No parameter should have been parsed for this command.");
                }
                case "internal": {
                    if (this.params.isEmpty()) {
                        collectedAgentCards = AgentCardCmdUtils.splitExternalAgents(AgentCardCmdUtils.collectAgentCards(is, os), true, false);
                        break;
                    }
                    throw new ParameterUsageException("No parameter should have been parsed for this command.");
                }
                default: {
                    throw new UnknownActionException("Unknown action was parsed!", this.action);
                }
            }
            ArrayList tmpParams = new ArrayList(this.params);
            for (AbstractAgentCard key : collectedAgentCards.values()) {
                if (!this.action.equals("agtid") && !this.action.equals("agtname")) {
                    tmpMsg.append(this.agentIDtoStatus(key)).append('\n');
                    continue;
                }
                if (this.params.size() == 0) {
                    throw new ParameterUsageException("Missing Parameters");
                }
                if (!tmpParams.contains(key.getAgentID())) continue;
                tmpMsg.append(this.agentIDtoStatus(key)).append('\n');
                tmpParams.remove(key.getAgentID());
            }
            if (!tmpParams.isEmpty()) {
                tmpMsg.append("There is a problem with the AgentID parsed! ").append(tmpParams);
                throw new CommandProcessingException(tmpMsg.toString().trim());
            }
            return new CommandResult(tmpMsg.toString().trim());
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new CommandProcessingException("An error occured during status while processing the action.", e);
        }
    }
}

