/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.agt;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.agt.AgentCardCmdUtils;
import com.boom.server.cli.cmds.nodegroup.NodeGroupUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LinkAgentToNodeGroup
extends AbstractCommand {
    public static final String COMMAND = "LINK_AGENT";

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
    }

    @Override
    public String getUsage() {
        Object usage = "LINK_AGENT\n";
        usage = (String)usage + "\tjava -jar boom_cli.jar -f <conffile> -c LINK_AGENT -cc <path> -a <agentId1> -a <agentId2> ...\n";
        usage = (String)usage + "\tDESCRIPTION\t" + ListOfCommands.LINK_AGENT.getDescription() + "\n";
        usage = (String)usage + "\tCOMMAND -c \"LINK_AGENT\"\n";
        usage = (String)usage + "\tEXAMPLES java -jar boom_cli.jar -f boom_cli.cfg -c LINK_AGENT -cc \"/root/_Groups/GroupA/GroupA1\" -a 8c5a4152-6928-4846-9e20-8ded4230589b";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        if (this.action == null) {
            throw new UnknownActionException("No action was parsed!", null);
        }
        if (this.params.isEmpty()) {
            throw new ParameterUsageException("Missing Parameters", this.params);
        }
        StringBuilder tmpMsg = new StringBuilder();
        try {
            Map<String, AbstractAgentCard> collectedAgents = AgentCardCmdUtils.collectAgentCards(is, os);
            for (String agentID : this.params) {
                if (!collectedAgents.containsKey(agentID)) {
                    throw new CommandProcessingException("AgentID " + agentID + " does not exist.");
                }
                os.writeUTF("NG_LINKAGENT");
                os.writeUTF(NodeGroupUtils.normalizePath(this.action));
                os.writeInt(1);
                os.writeUTF(agentID);
                tmpMsg.append("Successfully linked Agent: ").append(agentID).append("\n");
            }
            if (is.readUTF().equals("T")) {
                return new CommandResult(tmpMsg.toString());
            }
            throw new CommandProcessingException("The server could not link all the agents!");
        }
        catch (CommandProcessingException e) {
            throw new CommandProcessingException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new CommandProcessingException("There was a problem when executing the collection of agent cards.", e);
        }
    }
}

