/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.agt;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.in.ScPutAgent;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.agt.AgentCardCmdUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class MirrorAgents
extends AbstractCommand {
    public static final String CMD_MIRROR_AGENTS = "MIRROR_AGENTS";
    public static final String COMMAND = "MIRROR_AGENTS";
    private IServerAuth auth;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.auth = auth;
    }

    @Override
    public String getUsage() {
        Object usage = "MIRROR_AGENTS";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c MIRROR_AGENTS";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.MIRROR_AGENT.getDescription() + "\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"MIRROR_AGENTS\"";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c MIRROR_AGENTS";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        try {
            return this.mirrorAgents(is, os);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CommandProcessingException("An error occurred during status while processing the action.", e);
        }
    }

    protected CommandResult mirrorAgents(SDataInputStream is, SDataOutputStream os) throws IOException, IllegalAccessException, InstantiationException, CommandProcessingException {
        Object output = "";
        Map<String, AbstractAgentCard> collectedAgentCards = AgentCardCmdUtils.splitExternalAgents(AgentCardCmdUtils.collectAgentCards(is, os), true, false);
        try {
            ScPutAgent sc = new ScPutAgent(this.auth, collectedAgentCards.values().toArray(new AbstractAgentCard[0]));
            sc.run();
            if (sc.isSuccess()) {
                output = (String)output + "Mirror Agents successfully finish.\n";
            } else {
                output = (String)output + "[ERROR] Cannot mirror Agents.\n";
                output = (String)output + sc.getResultObject() + "\n";
            }
        }
        catch (Throwable e) {
            output = (String)output + "[ERROR] Cannot mirror Agents!\n";
            output = (String)output + e.getMessage() + "\n";
            return new CommandResult((String)output, -99);
        }
        return new CommandResult((String)output);
    }
}

