/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.agt;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.CliCommandFactory;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.nodegroup.NodeGroupUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UnLinkAgentToNodeGroup
extends AbstractCommand {
    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
    }

    @Override
    public String getUsage() {
        String usage = this.command + "\n";
        usage = usage + "\tjava -jar boom_cli.jar -f <conffile> -c UNLINK_AGENT -a <PathagentId1> -a <PathagentId2> ...\n";
        usage = usage + "\tDESCRIPTION\t" + ListOfCommands.UNLINK_AGENT.getDescription() + "\n";
        usage = usage + "\tCOMMAND -c \"UNLINK_AGENT\"\n";
        usage = usage + "\tEXAMPLES java -jar boom_cli.jar -f boom_cli.cfg -c UNLINK_AGENT -a /root/_Groups/TestGroup/8c5a4152-6928-4846-9e20-8ded4230589b";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        if (this.action != null) {
            throw new UnknownActionException("Unrequired action was parsed!", this.action);
        }
        if (this.params.isEmpty()) {
            throw new ParameterUsageException("Missing Parameters", this.params);
        }
        try {
            CliCommandFactory fact = new CliCommandFactory();
            AbstractCommand allAgentPaths = fact.getCommand("GETNODEGROUPS", "listagentpaths", Collections.emptyList(), null, "\t", null);
            List<String> allAgentPathsArray = Arrays.asList(allAgentPaths.executeCommand(is, os).getOutput().split("\n"));
            StringBuilder tmpMsg = new StringBuilder();
            os.writeUTF("NG_UNLINKAGENT");
            os.writeInt(this.params.size());
            for (String path : this.params) {
                String ngPath = NodeGroupUtils.normalizePath(path);
                if (allAgentPathsArray.contains(ngPath)) {
                    os.writeUTF(ngPath);
                    tmpMsg.append("Successfully unlinked Agents: ").append(ngPath).append("\n");
                    continue;
                }
                throw new CommandProcessingException("Agent with path " + path + " does not exist.");
            }
            if (is.readUTF().equals("T")) {
                return new CommandResult(tmpMsg.toString());
            }
            throw new CommandProcessingException("The server could not unlink all the agents!");
        }
        catch (Exception e) {
            throw new CommandProcessingException(e.getMessage(), e);
        }
    }
}

