/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.deploy;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.Assignment;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.agt.AgentCardCmdUtils;
import com.boom.server.cli.cmds.deploy.DeploymentHelper;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeployIfNotDeployed
extends AbstractCommand {
    public static final String CMD_DEPLOY = "DEPLOY";
    public static final String CMD_DEPLOY_IF_NOTDEPLOYED = "DEPLOY_IF_NOTDEPLOYED";
    public static final String COMMAND = "DEPLOY_IF_NOTDEPLOYED";
    private static final String HOST_PATTERN = "host_pattern=";
    private static final String ID_LIST = "id_list=";
    private static final String PGA = "pga=";
    private static final String ASN = "asn=";
    private IServerAuth auth;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.auth = auth;
    }

    @Override
    public String getUsage() {
        Object usage = "\nDEPLOY_IF_NOTDEPLOYED";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c DEPLOY_IF_NOTDEPLOYED -a host_pattern=<pattern>|id_list=<AgentID's separated by comma> -a pga=<Assignment names separated by comma>";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.DEPLOY_IF_NOTDEPLOYED.getDescription() + "\n";
        usage = (String)usage + "\n\t\t\tThe deployment process will only be started if the objects are not deployed to any agents!";
        usage = (String)usage + "\n\tCOMMAND -c\t\"DEPLOY_IF_NOTDEPLOYED\"";
        usage = (String)usage + "\n\tARGUMENTS\tPair of 2 arguments:";
        usage = (String)usage + "\n\t\t\thost_pattern=<pattern> or id_list=<AgentID's separated by comma>";
        usage = (String)usage + "\n\t\t\t-a pga=<Assignment names separated by comma>";
        usage = (String)usage + "\n\tEXAMPLES\tDeploy Assignment and Policy if they are not yet deployed:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c DEPLOY_IF_NOTDEPLOYED -a id_list=ed08da94-7aaf-4d3b-afe1-477538b0fd4f -a pga=BOOM-Basic";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        try {
            return this.deployIfNotDeployed(this.params.toArray(new String[0]), is, os);
        }
        catch (IllegalAccessException | InstantiationException e) {
            return new CommandResult("Could not get agent cards", -99);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new CommandResult("Command execution has been interrupted", -99);
        }
    }

    protected CommandResult deployIfNotDeployed(String[] args, SDataInputStream is, SDataOutputStream os) throws IOException, IllegalAccessException, InstantiationException, CommandProcessingException, InterruptedException {
        if (args == null || args.length < 1 || args.length % 2 != 0 || this.params.size() > 2 || this.action != null) {
            return new CommandResult("Incorrect parameters!", -1);
        }
        int res = 0;
        StringBuilder output = new StringBuilder();
        Map<String, AbstractAgentCard> agents = AgentCardCmdUtils.splitExternalAgents(AgentCardCmdUtils.collectAgentCards(is, os), true, false);
        if (agents.isEmpty()) {
            return new CommandResult("No AgentCards found on the server!", -16);
        }
        String hostP = null;
        Pattern hostPattern = null;
        String ids = null;
        LinkedList<String> asnGroupNames = new LinkedList<String>();
        ArrayList<String> agentIDs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith(HOST_PATTERN)) {
                hostP = arg.substring(HOST_PATTERN.length());
                try {
                    hostPattern = Pattern.compile(hostP);
                    continue;
                }
                catch (Throwable e) {
                    return new CommandResult("Invalid pattern " + arg + "\n" + e.getMessage(), -1);
                }
            }
            if (arg.startsWith(ID_LIST)) {
                ids = arg;
                continue;
            }
            if (!arg.startsWith(PGA) && !arg.startsWith(ASN)) continue;
            String names = arg.substring(PGA.length());
            String[] pgaNames = names.split("\\s*,\\s*");
            asnGroupNames.addAll(Arrays.asList(pgaNames));
        }
        if (hostPattern == null && ids == null) {
            return new CommandResult("Expected:\n-a host_pattern=<Javapattern> \nor\n-a id_list=<AgentID's separated by comma>", -1);
        }
        if (asnGroupNames.isEmpty() || asnGroupNames.size() == 1 && ((String)asnGroupNames.get(0)).equals("")) {
            return new CommandResult("Expected:\n-a pga=<Assignment names separated by comma>", -1);
        }
        if (hostPattern != null) {
            for (AbstractAgentCard acl : agents.values()) {
                Matcher m = hostPattern.matcher(acl.getAgentHost());
                if (!m.matches() || !acl.isApproved() || acl.getOSName() == null || acl.getOSName().contains("Connecting")) continue;
                agentIDs.add(acl.getAgentID());
            }
            if (agentIDs.isEmpty()) {
                return new CommandResult("There is a problem with the hosts supplied", -1);
            }
        } else {
            String[] arr = ids.substring(ID_LIST.length()).split("\\s*,\\s*");
            for (int k = 0; k < arr.length; ++k) {
                arr[k] = arr[k].trim();
                if (arr[k].length() <= 0 || !agents.containsKey(arr[k])) {
                    return new CommandResult("There is a problem with the agentIDs supplied", -1);
                }
                agentIDs.add(arr[k]);
            }
        }
        for (String asnName : asnGroupNames) {
            if (asnName == null || asnName.length() == 0) continue;
            CommandResult deploymentResult = this.deployIfNotDeployed2(is, os, res, new ArrayList<String>(agentIDs), asnName, agents);
            res = deploymentResult.getCode();
            output.append(deploymentResult.getOutput());
        }
        return new CommandResult(output.toString().trim(), res);
    }

    private CommandResult deployIfNotDeployed2(SDataInputStream is, SDataOutputStream os, int res, List<String> agentIDs, String asnName, Map<String, AbstractAgentCard> agents) throws IOException, CommandProcessingException, InterruptedException, IllegalAccessException, InstantiationException {
        StringBuilder output = new StringBuilder();
        List<Assignment> assignments = DeploymentHelper.getAllAssignments(is, os);
        for (Assignment asn : assignments) {
            boolean isSelected;
            if (!asnName.equalsIgnoreCase(asn.getName()) || !"pga".equalsIgnoreCase(asn.getType()) || !(isSelected = agentIDs.remove(asn.getAgentID()))) continue;
            try {
                output.append("Assignment already found for Agent: ").append(agents.get(asn.getAgentID()).getAgentHost()).append("\n");
            }
            catch (Throwable throwable) {}
        }
        if (agentIDs.isEmpty()) {
            output.append("Nothing to deploy. Assignment: ").append(asnName).append("\n");
        } else {
            output.append("Deploy Assignment Group: ").append(asnName).append("\n");
            for (String agtId : agentIDs) {
                output.append(" Processing agent: ").append(agtId).append("\n");
                CommandResult deploymentResult = DeploymentHelper.deploy(CMD_DEPLOY, agtId, new String[]{"pga", asnName}, is, os, this.auth);
                output.append(" > ").append(deploymentResult.getOutput()).append("\n");
                res = Math.max(deploymentResult.getCode(), res);
            }
        }
        return new CommandResult(output.toString().trim(), res);
    }
}

