/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.deploy;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.in.ScGetBinaryXmlAsString;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.Assignment;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.XMLTree;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.agt.AgentCardCmdUtils;
import com.boom.server.cli.cmds.pol.PolicyCommandUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeploymentHelper {
    public static final String CMD_GETASSIGNMENTS = "GETASSIGNMENTS";
    public static final String CMD_GET_ALL_ASSIGNMENTS = "GET_ALL_ASSIGNMENTS";

    private DeploymentHelper() {
    }

    protected static CommandResult deploy(String command, String action, String[] args, SDataInputStream is, SDataOutputStream os, IServerAuth auth) throws IOException, IllegalAccessException, InstantiationException, CommandProcessingException, InterruptedException {
        List<GroupTreeObject> allPolicies;
        if (action == null || action.length() < 1 || args == null || args.length < 1 || args.length % 2 != 0) {
            return new CommandResult("Incorrect parameters!", -1);
        }
        ArrayList<String> types = new ArrayList<String>();
        int res = 0;
        StringBuilder output = new StringBuilder();
        int unknown = 0;
        for (int i = 0; i < args.length; i += 2) {
            String objectType = args[i];
            if (objectType.equalsIgnoreCase("asn")) {
                args[i] = "pga";
                objectType = "pga";
            }
            if (!(objectType.equals("pkg") || objectType.equals("pga") || objectType.equals("mon") || objectType.equals("msg"))) {
                ++unknown;
                output.append("Unknown type: ").append(objectType).append("\n");
                continue;
            }
            if (types.contains(objectType)) continue;
            types.add(objectType);
        }
        if (unknown > 0) {
            return new CommandResult("Incorrect parameters!", -1);
        }
        Map<String, AbstractAgentCard> agents = AgentCardCmdUtils.splitExternalAgents(AgentCardCmdUtils.collectAgentCards(is, os), true, false);
        if (agents.isEmpty()) {
            return new CommandResult("No AgentCards found on the server!", -16);
        }
        AbstractAgentCard acl = agents.get(action);
        if (acl == null) {
            return new CommandResult("Agent not found: " + action, 4);
        }
        if (acl.getAgentPort() == 0) {
            return new CommandResult("Agent does not support deployments: " + action, 5);
        }
        if (!acl.isOnline()) {
            return new CommandResult("Agent is offline: " + action, 2);
        }
        GroupTreeObject packages = null;
        if (types.contains("pkg")) {
            packages = DeploymentHelper.getBinaries(is, os, auth);
            if (packages == null) {
                return new CommandResult("Error loading Packages!", -17);
            }
            if (!packages.hasElements().booleanValue()) {
                return new CommandResult("No Package found on the server!", -17);
            }
        }
        List<Object> assignmentNames = new ArrayList();
        if (types.contains("pga")) {
            assignmentNames = DeploymentHelper.getAssignments(is, os);
        }
        GroupTreeObject policiesTreeObject = null;
        if ((types.contains("mon") || types.contains("msg")) && (allPolicies = (policiesTreeObject = PolicyCommandUtils.parsePolicies(PolicyCommandUtils.getPolicies(is, os))).getAllElements()).isEmpty()) {
            return new CommandResult("No Policies found!", res);
        }
        int notExist = 0;
        int invalidNameType = 0;
        block12: for (int i = 0; i < args.length; i += 2) {
            String objectType = args[i];
            String element = args[i + 1];
            switch (objectType) {
                case "pkg": {
                    List<GroupTreeObject> pkgList = packages.findGroups(element, "pkg");
                    if (!pkgList.isEmpty()) continue block12;
                    output.append("Package not found: ").append(element);
                    ++notExist;
                    continue block12;
                }
                case "pga": {
                    boolean exist = false;
                    for (String string : assignmentNames) {
                        if (!string.equals(element)) continue;
                        exist = true;
                        break;
                    }
                    if (exist) continue block12;
                    output.append("Assignment not found: ").append(element);
                    ++notExist;
                    continue block12;
                }
                case "mon": 
                case "msg": {
                    boolean exist = false;
                    boolean valid = false;
                    List<GroupTreeObject> list = policiesTreeObject.getAllElements();
                    for (GroupTreeObject polGTO : list) {
                        if (!polGTO.getName().equals(element)) continue;
                        exist = true;
                        if (!polGTO.getType().equals(objectType)) continue;
                        valid = true;
                        break;
                    }
                    if (!exist) {
                        output.append("Policy not found: ").append(element);
                        ++notExist;
                        continue block12;
                    }
                    if (valid) continue block12;
                    output.append("Invalid combination of Policy Name/Type: ").append(objectType).append(" ").append(element);
                    ++invalidNameType;
                    continue block12;
                }
                default: {
                    return new CommandResult("Invalid Type: " + objectType, -1);
                }
            }
        }
        if (notExist > 0 || invalidNameType > 0) {
            res = 3;
            return new CommandResult(output.toString().trim(), res);
        }
        os.writeUTF(command);
        os.writeUTF(action);
        int size = args.length / 2;
        os.writeInt(size);
        for (int i = 0; i < args.length; i += 2) {
            String objectType = args[i];
            String objectName = args[i + 1];
            os.writeUTF(objectType);
            os.writeUTF(objectName);
        }
        String result = is.readUTF();
        if (result.equals("F")) {
            res = 1;
            return new CommandResult("AgentID does not exist on the server: " + action, res);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            if (command.contains("UNDEPLOY")) {
                output.append("UnDeployment successful!");
            } else {
                output.append("Deployment successful!");
            }
        } else {
            output.append("[ERROR] Deployment failed.");
            res = 1;
        }
        return new CommandResult(output.toString().trim(), res);
    }

    public static GroupTreeObject getBinaries(SDataInputStream is, SDataOutputStream os, IServerAuth auth) throws IOException, InterruptedException, CommandProcessingException {
        ScGetBinaryXmlAsString sc = new ScGetBinaryXmlAsString(auth);
        sc.runDirect(is, os);
        if (sc.isSuccess()) {
            ByteArrayInputStream bis = new ByteArrayInputStream(sc.getResultObject().getBytes());
            XMLTree xt = new XMLTree();
            return xt.parseXML(bis, true);
        }
        throw new CommandProcessingException("Binary Packages group file not found.", -8);
    }

    public static List<Assignment> getAllAssignments(SDataInputStream is, SDataOutputStream os) throws IOException, CommandProcessingException {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        os.writeUTF(CMD_GET_ALL_ASSIGNMENTS);
        while (is.readBoolean()) {
            Assignment asn = new Assignment();
            asn.read(is);
            assignments.add(asn);
        }
        String status = is.readUTF();
        if (!status.equals("T")) {
            throw new CommandProcessingException("[ERROR] cannot fetch Assignments " + status);
        }
        return assignments;
    }

    protected static List<String> getAssignments(SDataInputStream is, SDataOutputStream os) throws IOException, CommandProcessingException {
        ArrayList<String> assignmentNames = new ArrayList<String>();
        os.writeUTF(CMD_GETASSIGNMENTS);
        long size = is.readLong();
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)size);
        if (size >= 0L) {
            GroupTreeObject asnGTO;
            int blockSize = -1;
            byte[] inArr = new byte[1024];
            while ((blockSize = is.readInt()) != -1) {
                if (blockSize != 1024) {
                    inArr = new byte[blockSize];
                }
                is.readFully(inArr);
                baos.write(inArr);
            }
            XMLTree xt = new XMLTree();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            GroupTreeObject root = xt.parseXML(bais, true);
            if (root.getParent() == null && (asnGTO = root.getFirstChild("Assignments")) != null) {
                List<GroupTreeObject> asn = asnGTO.getElements();
                for (GroupTreeObject gto : asn) {
                    assignmentNames.add(gto.getName());
                }
            }
        } else {
            is.readUTF();
            throw new CommandProcessingException("Error loading Assignments!", -8);
        }
        String status = is.readUTF();
        if (!status.equals("T")) {
            throw new CommandProcessingException("[ERROR] cannot fetch Assignments " + status);
        }
        return assignmentNames;
    }
}

