/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.deploy;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.deploy.DeploymentHelper;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class PushPackage
extends AbstractCommand {
    public static final String CMD_TRIGGER_MASTER_UPDATE_SYNC = "TRIGGER_MASTER_UPDATE_SYNC";
    public static final String CMD_PUSH_PACKAGE = "PUSH_PACKAGE";
    public static final String ACT_UPD_BINARIES = "UPD_BINARIES";
    public static final String COMMAND = "PUSH_PACKAGE";
    private IServerAuth auth;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.auth = auth;
    }

    @Override
    public String getUsage() {
        Object usage = "\nPUSH_PACKAGE";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c PUSH_PACKAGE -cc <packageName>";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.PUSH_PACKAGE.getDescription() + "\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"PUSH_PACKAGE\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"BinaryPackage name\" (required)";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c PUSH_PACKAGE -cc package01";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        try {
            return this.processPushPackage(this.action, is, os);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new CommandResult("Could not get packages", -99);
        }
    }

    protected CommandResult processPushPackage(String pkgName, SDataInputStream is, SDataOutputStream os) throws IOException, CommandProcessingException, InterruptedException {
        if (pkgName == null || pkgName.length() == 0) {
            return new CommandResult("Incorrect parameters!", -1);
        }
        int res = 0;
        Object output = "";
        GroupTreeObject binaries = DeploymentHelper.getBinaries(is, os, this.auth);
        if (binaries == null) {
            return new CommandResult("Error loading Packages!", -17);
        }
        if (!binaries.hasElements().booleanValue()) {
            return new CommandResult("No Package found on the server!", -17);
        }
        List<GroupTreeObject> pkgList = binaries.findGroups(pkgName, "pkg");
        if (pkgList.isEmpty()) {
            return new CommandResult("Package not found: " + pkgName, 1);
        }
        os.writeUTF(CMD_TRIGGER_MASTER_UPDATE_SYNC);
        os.writeUTF("UPD_BINARIES " + pkgName);
        os.writeUTF("*");
        String resultOut = is.readUTF();
        String status = is.readUTF();
        if ("T".equals(status)) {
            output = resultOut.equals("") ? (String)output + "Empty server response. There are no slaves connected to the server." : (String)output + resultOut + "\n";
        } else {
            output = (String)output + resultOut + "\n";
            res = 2;
        }
        return new CommandResult((String)output, res);
    }
}

