/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.file;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.StrUtils;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.file.FileCmdUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class CreateFile
extends AbstractCommand {
    public static final String CMD_CREATE_FILE = "CREATE_FILE";
    public static final String CMD_PUT_FILE = "PUT_FILE";
    public static final String COMMAND = "CREATE_FILE";
    private StrUtils strUtils = new StrUtils();
    private IServerAuth auth;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.auth = auth;
    }

    @Override
    public String getUsage() {
        Object usage = "\nCREATE_FILE";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c CREATE_FILE -cc <packageName> -a <argument1>";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.CREATE_FILE.getDescription() + "\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"CREATE_FILE\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"BinaryPackage name\" (required)";
        usage = (String)usage + "\n\tARGUMENTS -a\tLocal file path (at least one argument must be specified)";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c CREATE_FILE -cc package01 -a myFile1.dat";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        try {
            return this.processCreateFile(this.action, this.params.toArray(new String[0]), is, os);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new CommandResult("Command execution has been interrupted", -99);
        }
    }

    protected CommandResult processCreateFile(String pkgName, String[] args, SDataInputStream is, SDataOutputStream os) throws IOException, CommandProcessingException, InterruptedException {
        StringBuilder output = new StringBuilder();
        if (pkgName == null || pkgName.length() == 0 || args == null || args.length < 1) {
            return new CommandResult("Incorrect parameters!", -1);
        }
        int res = 0;
        for (String arg : args) {
            File f = new File(arg);
            if (f.exists() && f.canRead()) continue;
            return new CommandResult("Local file not found or unreadable: " + arg, -8);
        }
        GroupTreeObject binaries = FileCmdUtils.getBinaries(is, os, this.auth);
        if (binaries == null) {
            return new CommandResult("Error loading Packages!", -17);
        }
        if (!binaries.hasElements().booleanValue()) {
            return new CommandResult("No Package found on the server!", -17);
        }
        List<GroupTreeObject> pkgList = binaries.findGroups(pkgName, "pkg");
        if (pkgList.isEmpty()) {
            return new CommandResult("Package not found: " + pkgName, 1);
        }
        Object path = pkgName;
        if (!((String)path).startsWith("srv/packages/")) {
            if (((String)path).startsWith("/")) {
                path = ((String)path).substring(1);
            }
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            path = "srv/packages/" + (String)path;
        } else if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        GroupTreeObject pkg = pkgList.get(0);
        String[] stringArray = args;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String arg;
            String fileName = arg = stringArray[i];
            File f = new File(fileName = this.strUtils.removeQuotes(fileName));
            GroupTreeObject fileGTOL = pkg.getChild(f.getName(), "file");
            if (fileGTOL != null) {
                output.append("File does already exist in package '").append(pkgName).append("': ").append(f.getName()).append("\n");
                ++res;
                continue;
            }
            String srvPath = (String)path + f.getName();
            os.writeUTF(CMD_PUT_FILE);
            os.writeUTF(srvPath);
            FileInputStream fis = new FileInputStream(f);
            os.writeFile(fis);
            fis.close();
            String status = is.readUTF();
            if (status.equals("T")) {
                output.append("File created: ").append(srvPath).append("\n");
                continue;
            }
            output.append("Cannot create server file ").append(srvPath).append("\n");
            ++res;
        }
        if (res > 1) {
            res = 2;
        }
        return new CommandResult(output.toString().trim(), res);
    }
}

