/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.file;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.file.FileCmdUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DeleteFile
extends AbstractCommand {
    public static final String CMD_DELETE_FILE = "DELETE_FILE";
    public static final String COMMAND = "DELETE_FILE";
    private IServerAuth auth;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.auth = auth;
    }

    @Override
    public String getUsage() {
        Object usage = "\nDELETE_FILE";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c DELETE_FILE -cc <packageName> -a <argument1>";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.DELETE_FILE.getDescription() + "\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"DELETE_FILE\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"BinaryPackage name\" (required)";
        usage = (String)usage + "\n\tARGUMENTS -a\tFile path (at least one argument must be specified)";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c DELETE_FILE -cc package01 -a myFile1.dat";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        try {
            return this.processDeleteFile(this.action, this.params.toArray(new String[0]), is, os);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new CommandResult("Command execution has been interrupted", -99);
        }
    }

    protected CommandResult processDeleteFile(String action, String[] args, SDataInputStream is, SDataOutputStream os) throws IOException, CommandProcessingException, InterruptedException {
        int res = 0;
        StringBuilder output = new StringBuilder();
        if (args == null || args.length < 1) {
            return new CommandResult("Incorrect parameters!", -1);
        }
        String[] pathes = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("/")) {
                args[i] = args[i].substring(1);
            }
            pathes[i] = "/root/Packages/" + action + "/" + args[i];
            if (args[i].startsWith("srv/packages/")) continue;
            args[i] = "srv/packages/" + action + "/" + args[i];
        }
        GroupTreeObject binaries = FileCmdUtils.getBinaries(is, os, this.auth);
        if (binaries == null) {
            return new CommandResult("Error loading Packages!", -17);
        }
        if (!binaries.hasElements().booleanValue()) {
            return new CommandResult("No Package found on the server!", -17);
        }
        for (int i = 0; i < args.length; ++i) {
            String path = pathes[i];
            GroupTreeObject gto = binaries.searchPath(path, "file");
            if (gto != null) {
                os.writeUTF("DELETE_FILE");
                os.writeUTF(args[i]);
                String status = is.readUTF();
                if (!status.equals("T")) {
                    ++res;
                    output.append("Error deleting file: ").append(path.replace("/root/Packages/", "")).append("\n");
                    continue;
                }
                output.append("File deleted: ").append(path.replace("/root/Packages/", "")).append("\n");
                continue;
            }
            ++res;
            output.append("File not found: ").append(path.replace("/root/Packages/", "")).append("\n");
        }
        if (res > 1) {
            res = 2;
        }
        return new CommandResult(output.toString().trim(), res);
    }
}

