/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.file;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.in.ScDeleteFolder;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DeleteFolder
extends AbstractCommand {
    public static final String CMD_DELETE_FOLDER = "DELETE_FOLDER";
    public static final String COMMAND = "DELETE_FOLDER";
    private IServerAuth auth;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.auth = auth;
    }

    @Override
    public String getUsage() {
        Object usage = "DELETE_FOLDER";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c DELETE_FOLDER [-cc <folderpath> ]";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.DELETE_FOLDER.getDescription() + "\n";
        usage = (String)usage + "\n\t\t\tPath must relative be to server root";
        usage = (String)usage + "\n\tCOMMAND -c\t\"DELETE_FOLDER\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"folder\"";
        usage = (String)usage + "\n\tEXAMPLE\t ";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c DELETE_FOLDER -cc srv/packages/testfolder";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        int res = 0;
        Object output = "";
        ScDeleteFolder sc = new ScDeleteFolder(this.auth, this.action);
        try {
            sc.runDirect(is, os);
            if (sc.isSuccess()) {
                output = (String)output + "Successfully deleted folder: " + this.action + "\n";
            } else {
                output = (String)output + "Failed to delete folder: " + sc.getResultObject() + "\n";
                res = -99;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            output = "Command execution has been interrupted";
            res = -99;
        }
        return new CommandResult(((String)output).trim(), res);
    }
}

