/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.file;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.agt.AgentCardCmdUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class GetFileFromAgent
extends AbstractCommand {
    public static final String CMD_BOOM_AGENT_GETFILE = "BOOM_AGENT_GETFILE";
    public static final String CMD_ACTION = "ACTION";
    public static final String COMMAND = "BOOM_AGENT_GETFILE";

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
    }

    @Override
    public String getUsage() {
        Object usage = "\nBOOM_AGENT_GETFILE";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c BOOM_AGENT_GETFILE -cc <AgentID> -a <localFilePath> -a <remoteFilePath>";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.BOOM_AGENT_GETFILE.getDescription();
        usage = (String)usage + "\n\t\t\tThe file will be downloaded to the system the server is running on\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"BOOM_AGENT_GETFILE\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"AgentID\" (required)";
        usage = (String)usage + "\n\tARGUMENTS -a\t\"localFilePath\" -a\t\"remoteFilePath\" (required)";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        if (this.params.size() == 2) {
            try {
                return GetFileFromAgent.getAgentFile(is, os, (String)this.params.get(1), (String)this.params.get(0), this.action);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CommandProcessingException("Could not process command", e, -16);
            }
        }
        return new CommandResult("Incorrect parameters!", -1);
    }

    protected static CommandResult getAgentFile(SDataInputStream is, SDataOutputStream os, String localFile, String remotePath, String agentId) throws IOException, IllegalAccessException, InstantiationException, CommandProcessingException {
        int res = 0;
        Object output = "";
        os.writeUTF(CMD_ACTION);
        os.writeUTF(UUID.randomUUID().toString());
        os.writeUTF("BOOM_AGENT_GETFILE \"" + remotePath + "\" \"" + localFile + "\"");
        os.writeUTF(agentId);
        os.writeInt(600);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommandProcessingException("Wait has been interrupted", e, -99);
        }
        String text = is.readUTF();
        if ("F".equals(text)) {
            Map<String, AbstractAgentCard> collectedAgentCards = AgentCardCmdUtils.splitExternalAgents(AgentCardCmdUtils.collectAgentCards(is, os), true, false);
            CommandResult checkResult = AgentCardCmdUtils.getAgentsByID(collectedAgentCards, new String[]{agentId}, is, os);
            output = (String)output + checkResult.getOutput() + "\n";
            if (checkResult.getCode() != 0) {
                res = -7;
            } else {
                res = -14;
                output = (String)output + "Error running Action BOOM_AGENT_GETFILE\n";
            }
            return new CommandResult((String)output, res);
        }
        String okay = is.readUTF();
        if (okay.equals("T")) {
            output = (String)output + "Action finished. BOOM_AGENT_GETFILE\n";
            if (text.contains("Remote file not found")) {
                res = 1;
            } else if (text.contains("Local file already exist")) {
                res = -15;
            }
            output = (String)output + text + "\n";
        } else {
            output = (String)output + "Error running Action BOOM_AGENT_GETFILE\n";
            output = (String)output + text + "\n";
            res = -14;
        }
        return new CommandResult((String)output, res);
    }
}

