/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.file;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class PutFile
extends AbstractCommand {
    public static final String CMD_PUT_FILE = "PUT_FILE";
    public static final String COMMAND = "PUT_FILE";

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
    }

    @Override
    public String getUsage() {
        Object usage = "\nPUT_FILE";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c PUT_FILE -cc <packageName> -a <argument1>";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.PUT_FILE.getDescription();
        usage = (String)usage + "\n\t\t\tThe file has to be on the system the cli command is started from.\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"PUT_FILE\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"BinaryPackage name\" (required)";
        usage = (String)usage + "\n\tARGUMENTS -a\tLocal file path (at least one argument must be specified)";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c PUT_FILE -cc package01 -a myFile1.dat";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        return this.processUploadFileForce(this.action, this.params.toArray(new String[0]), is, os);
    }

    protected CommandResult processUploadFileForce(String pkgName, String[] args, SDataInputStream is, SDataOutputStream os) throws IOException {
        if (pkgName == null || pkgName.length() == 0 || args == null || args.length < 1) {
            return new CommandResult("Incorrect parameters!", -1);
        }
        int res = 0;
        StringBuilder output = new StringBuilder();
        for (String arg : args) {
            File f = new File(arg);
            if (f.exists() && f.canRead()) continue;
            return new CommandResult("Local file not found or unreadable: " + arg, -8);
        }
        StringBuilder pkgNameBuilder = new StringBuilder(pkgName);
        for (String arg : args) {
            String path;
            File f = new File(arg);
            Object pkg = pkgNameBuilder.toString();
            if (!((String)pkg).startsWith("srv/packages/")) {
                if (((String)pkg).startsWith("/")) {
                    pkg = ((String)pkg).substring(1);
                }
                if (!((String)pkg).endsWith("/")) {
                    pkg = (String)pkg + "/";
                }
                path = "srv/packages/" + (String)pkg + f.getName();
            } else {
                if (!pkgNameBuilder.toString().endsWith("/")) {
                    pkgNameBuilder.append("/");
                }
                path = String.valueOf(pkgNameBuilder) + f.getName();
            }
            os.writeUTF("PUT_FILE");
            os.writeUTF(path);
            FileInputStream fis = new FileInputStream(f);
            os.writeFile(fis);
            fis.close();
            String status = is.readUTF();
            if (status.equals("T")) {
                output.append("File uploaded: ").append(path).append("\n");
                continue;
            }
            output.append("Cannot create server file ").append(path).append("\n");
            ++res;
        }
        pkgName = pkgNameBuilder.toString();
        return new CommandResult(output.toString().trim(), res);
    }
}

