/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.indi;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.in.ScPutAnnotation;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class AddIndicationAnnotation
extends AbstractCommand {
    public static final String CMD_ADD_ANNOTATION = "ADD_ANNOTATION";
    public static final String COMMAND = "ADD_ANNOTATION";
    private IServerAuth auth;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.auth = auth;
    }

    @Override
    public String getUsage() {
        Object usage = "\nADD_ANNOTATION";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c ADD_ANNOTATION -cc <indicationId> -a <annotationtext>";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.ADD_ANNOTATION.getDescription() + "\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"ADD_ANNOTATION\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"indication ID\" (required)";
        usage = (String)usage + "\n\tARGUMENTS -a\t\"annotation text\" (required)";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c ADD_ANNOTATION -cc f2e0682b-5e08-4f70-9209-38c42316f112 -a \"some annotation text\"";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        int res = 0;
        Object output = "";
        StringBuilder sb = new StringBuilder();
        for (String annotationText : this.params) {
            sb.append(annotationText).append('\n');
        }
        ScPutAnnotation sc = new ScPutAnnotation(this.auth, this.action, sb.toString());
        try {
            sc.runDirect(is, os);
            if (sc.isSuccess()) {
                output = (String)output + "Successfully set annotation for indication ID: " + this.action + "\n";
            } else {
                output = (String)output + "Failed to set annotation: " + sc.getResultObject() + "\n";
                res = -99;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            output = "Command execution has been interrupted";
            res = -99;
        }
        return new CommandResult((String)output, res);
    }
}

