/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.indi;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.auth.ScGetUsers;
import com.blixx.shared.User;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.CommandResult;

public class IndicationCommandUtil {
    public static final String CMD_ACKNOWLEDGEMSG = "ACKN_MSG";
    public static final String CMD_CLOSEMSGS = "CLOSE_MSG";
    public static final String CMD_ARCHIVEMSG = "ARCH_MSG";
    public static final String CMD_DELETEMSG = "DELETE_MSG";
    public static final String CMD_CLOSEINDI = "CLOSE_INDI";
    public static final String CMD_ARCHIVEINDI = "ARCH_INDI";
    public static final String CMD_DELETEINDI = "DELETE_INDI";

    public static CommandResult processIndication(SDataInputStream is, SDataOutputStream os, String command, String indicationIDs) {
        int res = 0;
        String output = "";
        try {
            if (indicationIDs == null || indicationIDs.length() == 0) {
                return new CommandResult("Indication IDs must be specified. Use -cc \"ID1,ID2,...\"", -99);
            }
            indicationIDs = indicationIDs.replaceAll("[^\\w\\-]+", ",");
            if (CMD_CLOSEMSGS.equalsIgnoreCase(command) || CMD_CLOSEINDI.equalsIgnoreCase(command)) {
                command = CMD_ACKNOWLEDGEMSG;
            }
            if (CMD_ARCHIVEINDI.equalsIgnoreCase(command)) {
                command = CMD_ARCHIVEMSG;
            }
            if (CMD_DELETEINDI.equalsIgnoreCase(command)) {
                command = CMD_DELETEMSG;
            }
            os.writeUTF(command);
            os.writeUTF(indicationIDs);
            String text = is.readUTF();
            String status = is.readUTF();
            if ("T".equals(status)) {
                output = text;
            } else {
                output = text;
                res = -99;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new CommandResult(output, res);
    }

    /*
     * WARNING - void declaration
     */
    public static CommandResult processOwnDisownIndication(SDataInputStream is, SDataOutputStream os, String command, String indicationIDs, String user, IServerAuth auth) {
        int res = 0;
        Object output = "";
        try {
            void var12_17;
            String[] users;
            if (indicationIDs == null || indicationIDs.length() == 0) {
                return new CommandResult("Indication IDs must be specified. Use -cc \"ID1,ID2,...\"", -99);
            }
            indicationIDs = indicationIDs.replaceAll("[^\\w\\-]+", ",");
            if (user == null) {
                throw new RuntimeException("User can't be null");
            }
            ScGetUsers sc = new ScGetUsers(auth);
            sc.runDirect(is, os);
            if (sc.isSuccess()) {
                boolean userFound = false;
                users = sc.getResultObject();
                for (User user2 : users) {
                    if (!user.equals(user2.getLoginName())) continue;
                    userFound = true;
                    break;
                }
                if (!userFound) {
                    res = -99;
                    output = (String)output + "Unknown user: " + user;
                }
            } else {
                res = -99;
                output = (String)output + " " + sc.getLastException().getMessage() + "\n";
            }
            String[] ids = new String[]{indicationIDs};
            if (indicationIDs.indexOf(44) != -1) {
                ids = indicationIDs.split("\\s*,\\s*");
            }
            os.writeUTF(command);
            os.writeUTF(user);
            os.writeInt(ids.length);
            users = ids;
            int n = users.length;
            boolean bl = false;
            while (var12_17 < n) {
                String id = users[var12_17];
                os.writeUTF(id);
                ++var12_17;
            }
            String status = is.readUTF();
            if ("T".equals(status)) {
                output = (String)output + "Done\n";
            } else {
                output = status.length() > 1 ? (String)output + "Failed: " + status + "\n" : (String)output + "Failed\n";
                res = -99;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new CommandResult((String)output, res);
    }
}

