/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.indi;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.in.ScUpdateIndicationAttribute;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class SetIndicationCustomAttribute
extends AbstractCommand {
    public static final String CMD_SET_CA = "SET_CA";
    public static final String COMMAND = "SET_CA";
    private IServerAuth auth;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.auth = auth;
    }

    @Override
    public String getUsage() {
        Object usage = "\nSET_CA";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c SET_CA -cc <indicationID> -a <attributeName> -a <attributeValue>";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.SET_CA.getDescription() + "\n";
        usage = (String)usage + "\n\t\t\tCustom attributes: CA1 ... CA15. Values in the form of name=value";
        usage = (String)usage + "\n\tCOMMAND -c\t\"SET_CA\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"indicationID\" (required)";
        usage = (String)usage + "\n\tARGUMENTS -a\t\"attributeName\" -a\t\"attributeValue\" (required)";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c SET_CA -cc 125a4152-6928-4846-9e20-8ded4230589b -a CA1 -a \"MyAttribute=My value\"";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        if (this.params.size() == 2) {
            int res = 0;
            Object output = "";
            ScUpdateIndicationAttribute sc = new ScUpdateIndicationAttribute(this.auth, this.action, (String)this.params.get(0), (String)this.params.get(1));
            try {
                sc.runDirect(is, os);
                if (sc.isSuccess()) {
                    output = (String)output + "Successfully set attribute for indication: " + this.action + "\n";
                } else {
                    output = (String)output + "Failed to set attribute: " + String.valueOf(sc.getResultObject());
                    res = -99;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CommandProcessingException("Command execution has been interrupted", e, -99);
            }
            return new CommandResult((String)output, res);
        }
        return new CommandResult("Incorrect parameters!", -1);
    }
}

