/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.nodegroup;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.nodegroup.NodeGroupUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DeleteNodeGroup
extends AbstractCommand {
    public static final String COMMAND = "DELETE_NODEGROUP";

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
    }

    @Override
    public String getUsage() {
        Object usage = "DELETE_NODEGROUP\n";
        usage = (String)usage + "\tjava -jar boom_cli.jar -f <conffile> -c DELETE_NODEGROUP -a <path> \n";
        usage = (String)usage + "\tDESCRIPTION\t" + ListOfCommands.DELETE_NODEGROUP.getDescription() + "\n";
        usage = (String)usage + "\t\t\tIf node group does not exists - does nothing.\n";
        usage = (String)usage + "\t\t\tAlways parse paths without trailing slashes.\n";
        usage = (String)usage + "\tCOMMAND\t -c \"DELETE_NODEGROUP \"\n";
        usage = (String)usage + "\tARGUMENTS\t -a \"path1\" -a \"path2\" ... (required)\n";
        usage = (String)usage + "\tEXAMPLES\t java -jar boom_cli.jar -f boom_cli.cfg -c DELETE_NODEGROUP  -a /GroupA/GroupA1";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        StringBuilder tmpMsg = new StringBuilder();
        if (this.params.isEmpty()) {
            throw new ParameterUsageException("Missing Parameters");
        }
        for (String path : this.params) {
            os.writeUTF("NG_DEL");
            os.writeInt(1);
            path = NodeGroupUtils.normalizePath(path);
            os.writeUTF(path);
            if (is.readUTF().equals("T")) {
                tmpMsg.append("node groups deleted\n");
                continue;
            }
            tmpMsg.append(path).append(" could not be removed!\n");
        }
        return new CommandResult(tmpMsg.toString());
    }
}

