/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.nodegroup;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.XMLTree;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.agt.AgentCardCmdUtils;
import com.boom.server.cli.cmds.nodegroup.NodeGroupUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetAgentIDs4NG
extends AbstractCommand {
    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, CommandProcessingException {
        if (this.action == null) {
            throw new UnknownActionException("No node group path was specified!", null);
        }
        StringBuilder tmpMsg = new StringBuilder();
        try {
            GroupTreeObject nodeGroup;
            Map<String, AbstractAgentCard> agentCards = AgentCardCmdUtils.splitExternalAgents(AgentCardCmdUtils.collectAgentCards(is, os), true, true);
            String xmlAsString = NodeGroupUtils.getXml(is, os);
            GroupTreeObject nodeGroupTree = new XMLTree().parseXML(new ByteArrayInputStream(xmlAsString.getBytes()), true);
            String ngPath = this.action;
            if (ngPath.endsWith("/")) {
                ngPath = ngPath.substring(0, ngPath.length() - 1);
            }
            if ((nodeGroup = nodeGroupTree.searchPath(ngPath, "")) != null) {
                nodeGroup.getElements().stream().filter(gto -> "agt".equalsIgnoreCase(gto.getType())).map(gtol -> (AbstractAgentCard)agentCards.get(gtol.getName())).filter(Objects::nonNull).forEach(ac -> tmpMsg.append(ac.getAgentID()).append("\n"));
                if (tmpMsg.isEmpty()) {
                    tmpMsg.append("no agents found").append("\n");
                }
            } else {
                tmpMsg.append("NodeGroup not found: ").append(ngPath);
            }
        }
        catch (Exception e) {
            throw new CommandProcessingException("An internal problem when running the command occurred.", e);
        }
        return new CommandResult(tmpMsg.toString());
    }

    @Override
    public String getUsage() {
        return "\n" + String.valueOf((Object)ListOfCommands.GETAGENTIDS4NG) + "\n\tjava -jar boom_cli.jar -f <conffile> -c " + String.valueOf((Object)ListOfCommands.GETAGENTIDS4NG) + " -cc <ngpath>\n\tDESCRIPTION\t" + ListOfCommands.GETAGENTIDS4NG.getDescription() + "\n\tEXAMPLE:java -jar boom_cli.jar -f boom_cli.cfg -c " + String.valueOf((Object)ListOfCommands.GETAGENTIDS4NG) + " -cc /root/_Groups/YourNodeGroup";
    }
}

