/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.nodegroup;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.XMLTree;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.nodegroup.NodeGroupUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;

public class GetAgentNodeGroups
extends AbstractCommand {
    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, CommandProcessingException {
        if (this.action == null) {
            throw new UnknownActionException("No agent ID was specified!", null);
        }
        StringBuilder tmpMsg = new StringBuilder();
        try {
            String xmlAsString = NodeGroupUtils.getXml(is, os);
            GroupTreeObject nodeGroupTree = new XMLTree().parseXML(new ByteArrayInputStream(xmlAsString.getBytes()), true);
            List<GroupTreeObject> foundLinks = nodeGroupTree.findAllGTOL(this.action, "agt");
            if (!foundLinks.isEmpty()) {
                foundLinks.forEach(gtol -> tmpMsg.append(gtol.getParentPath()).append("\n"));
            } else {
                tmpMsg.append("No node groups found for agent ID: ").append(this.action).append("\n");
            }
        }
        catch (Exception e) {
            throw new CommandProcessingException("An internal problem when running the command occurred.", e);
        }
        return new CommandResult(tmpMsg.toString());
    }

    @Override
    public String getUsage() {
        return "\n" + String.valueOf((Object)ListOfCommands.GETAGENTNODEGROUPS) + "\n\tjava -jar boom_cli.jar -f <conffile> -c " + String.valueOf((Object)ListOfCommands.GETAGENTNODEGROUPS) + " -cc <agentId>\n\tDESCRIPTION\t" + ListOfCommands.GETAGENTNODEGROUPS.getDescription() + "\n\tEXAMPLE:java -jar boom_cli.jar -f boom_cli.cfg -c " + String.valueOf((Object)ListOfCommands.GETAGENTNODEGROUPS) + " -cc 6ff38d81-9e79-4cb6-9571-a7e2622f3297";
    }
}

