/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.nodegroup;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.XMLTree;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.nodegroup.NodeGroupUtils;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GetNodeGroups
extends AbstractCommand {
    public static final String COMMAND = "GETNODEGROUPS";
    private String separator;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.separator = separator;
    }

    public String processListXmlObject(List<GroupTreeObject> xmlElements, String action) {
        StringBuilder tmpMsg = new StringBuilder();
        for (GroupTreeObject gto : xmlElements) {
            if ("listallpaths".equals(action) && !gto.getName().equals("_Groups")) {
                tmpMsg.append(gto.getPath()).append("\n");
            }
            if (gto.getName().equals("_Groups") || gto instanceof GroupTreeObjectLast) {
                if (!"listagentpaths".equals(action) || gto.getName().equals("_Groups")) continue;
                tmpMsg.append(gto.getPath()).append("\n");
                continue;
            }
            switch (action) {
                case "list": {
                    tmpMsg.append("\"").append(gto.getName()).append("\"").append(this.separator).append("\"").append(gto.getPath()).append("\"").append("\n");
                    break;
                }
                case "listnames": {
                    tmpMsg.append(gto.getName()).append("\n");
                    break;
                }
                case "listpaths": {
                    tmpMsg.append(gto.getPath()).append("\n");
                }
            }
        }
        return tmpMsg.toString().trim();
    }

    public String checkObjectsXml(GroupTreeObject nodeGroupTree, String action) throws ParameterUsageException {
        StringBuilder tmpMsg = new StringBuilder();
        if (this.params.isEmpty()) {
            throw new ParameterUsageException("Missing Parameters", this.params);
        }
        HashSet potentiallyNotFound = new HashSet(this.params);
        switch (action) {
            case "checkname": {
                for (String requested : this.params) {
                    List<GroupTreeObject> found = nodeGroupTree.getFirstChild("_Groups").findGroups(requested, "");
                    found.forEach(gto -> {
                        potentiallyNotFound.remove(requested);
                        tmpMsg.append(gto.getPath()).append("\n");
                    });
                }
                break;
            }
            case "checkpath": {
                for (String requested : this.params) {
                    GroupTreeObject found = nodeGroupTree.searchPath(requested, "");
                    if (found == null) {
                        found = nodeGroupTree.searchPath("/root/_Groups" + requested, "");
                    }
                    if (found == null) continue;
                    potentiallyNotFound.remove(requested);
                    tmpMsg.append(found.getPath()).append("\n");
                }
                break;
            }
        }
        potentiallyNotFound.forEach(str -> tmpMsg.append("NodeGroup not found: ").append((String)str).append("\n"));
        return tmpMsg.toString().trim();
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws ParameterUsageException, UnknownActionException, IOException {
        Object tmpMsg;
        String xmlAsString = NodeGroupUtils.getXml(is, os);
        if (this.action != null) {
            ByteArrayInputStream xmlAsBytes = new ByteArrayInputStream(xmlAsString.getBytes());
            XMLTree xt = new XMLTree();
            GroupTreeObject nodeGroupTree = xt.parseXML(xmlAsBytes, true);
            List<GroupTreeObject> xmlElements = nodeGroupTree.getAllElements();
            switch (this.action) {
                case "list": 
                case "listpaths": 
                case "listnames": 
                case "listallpaths": 
                case "listagentpaths": {
                    if (this.params.isEmpty()) {
                        tmpMsg = this.processListXmlObject(xmlElements, this.action);
                        break;
                    }
                    throw new ParameterUsageException("No parameter should have been parsed for this command.");
                }
                case "checkname": 
                case "checkpath": {
                    for (String param : this.params) {
                        if (!param.endsWith("/")) continue;
                        throw new ParameterUsageException("Node paths should not end with </>! ", this.params);
                    }
                    tmpMsg = this.checkObjectsXml(nodeGroupTree, this.action);
                    break;
                }
                case "print": {
                    tmpMsg = xmlAsString;
                    break;
                }
                default: {
                    throw new UnknownActionException("Unknown action was parsed!", this.action);
                }
            }
        } else {
            tmpMsg = "No action specified. use print.\n" + xmlAsString;
        }
        return new CommandResult((String)tmpMsg);
    }

    @Override
    public String getUsage() {
        Object usage = "\nGETNODEGROUPS";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c GETNODEGROUPS -cc <option> [-a <argument1>] [-a <argument2>] ...";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.GETNODEGROUPS.getDescription();
        usage = (String)usage + "\n\tCOMMAND\t\t\"GETNODEGROUPS\"";
        usage = (String)usage + "\n\tOPTION\t\t\"print\"|\"list\"|\"listnames\"|\"listpaths\"|\"checkname\"|\"checkpath\" (required)";
        usage = (String)usage + "\n\t\t\tprint:\t\tprint file nodeGroups.xml (arguments ignored)";
        usage = (String)usage + "\n\t\t\tlist:\t\tlist all NodeGroup names and their path (arguments ignored)";
        usage = (String)usage + "\n\t\t\tlistnames:\tlist all NodeGroup names only (arguments ignored)";
        usage = (String)usage + "\n\t\t\tlistpaths:\tlist all NodeGroup paths (arguments ignored)";
        usage = (String)usage + "\n\t\t\tlistallpaths:\tlist all NodeGroup and Linked Agents paths (arguments ignored)";
        usage = (String)usage + "\n\t\t\tlistagentpaths:\tlist all Linked Agents paths (arguments ignored). Agents which are not linked are ignored.";
        usage = (String)usage + "\n\t\t\tcheckname:\tcheck if NodeGroup does exist (Result code: indicates the number of not found NodeGroups)";
        usage = (String)usage + "\n\t\t\tcheckpath:\tcheck if NodeGroup path does exist (Result code: indicates the number of not found NodeGroups)";
        usage = (String)usage + "\n\tARGUMENTS\n\t\t\tNodeGroup name(s) - for checkname option\n\t\t\tpath(s) - for checkpath option";
        usage = (String)usage + "\n\tEXAMPLES\tCheck if the NodeGroups \"group01\" and \"group02\" do exist:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETNODEGROUPS -cc checkname -a group01 -a group02";
        usage = (String)usage + "\n\t\t\tCheck if NodeGroup path exist:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETNODEGROUPS -cc checkpath -a /root/_Groups/TEstMY";
        usage = (String)usage + "\n\t\t\tCheck if short (without /root/_Group) NodeGroup path exist:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETNODEGROUPS -cc checkpath -a /TEstMY";
        usage = (String)usage + "\n\t\t\tPrint nodegroups.xml file:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETNODEGROUPS -cc print";
        usage = (String)usage + "\n\t\t\tPrints paths and names of all existing NodeGroups:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETNODEGROUPS -cc list";
        usage = (String)usage + "\n\t\t\tPrints names of all existing NodeGroups:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETNODEGROUPS -cc listnames";
        usage = (String)usage + "\n\t\t\tPrints paths of all existing NodeGroups:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETNODEGROUPS -cc listpaths";
        usage = (String)usage + "\n\t\t\tPrints paths of all existing elements:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETNODEGROUPS -cc listallpaths";
        usage = (String)usage + "\n\t\t\tPrints paths of all Linked Agents:";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETNODEGROUPS -cc listagentpaths";
        return usage;
    }
}

