/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.nodegroup;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.nodegroup.NodeGroupUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class RenameNodeGroup
extends AbstractCommand {
    public static final String COMMAND = "RENAME_NODEGROUP";

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
    }

    @Override
    public String getUsage() {
        Object usage = "RENAME_NODEGROUP\n";
        usage = (String)usage + "\tjava -jar boom_cli.jar -f <conffile> -c RENAME_NODEGROUP -a <pathold> -a <pathnew>\n";
        usage = (String)usage + "\tDESCRIPTION\t" + ListOfCommands.RENAME_NODEGROUP.getDescription() + "\n";
        usage = (String)usage + "\t\t\tPaths should always be defined without trailing slashes\n";
        usage = (String)usage + "\tCOMMAND\t -c \"RENAME_NODEGROUP \"\n";
        usage = (String)usage + "\ttARGUMENTS\t -a \"oldpath\" -a \"newpath\" ... (required)\n";
        usage = (String)usage + "\tEXAMPLES\t java -jar boom_cli.jar -f boom_cli.cfg -c RENAME_NODEGROUP  -a /GroupA/GroupA1 -a /GroupA/GroupA1_new";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        if (this.params.size() != 2) {
            throw new ParameterUsageException("An inapropriate number of arguments was parsed", this.params);
        }
        os.writeUTF("NG_RNM");
        os.writeUTF(NodeGroupUtils.normalizePath((String)this.params.get(0)));
        os.writeUTF(NodeGroupUtils.normalizePath((String)this.params.get(1)));
        if (is.readUTF().equals("T")) {
            return new CommandResult((String)this.params.get(0) + " was renamed into: " + (String)this.params.get(1));
        }
        return new CommandResult((String)this.params.get(0) + " could not be renamed into: " + (String)this.params.get(1));
    }
}

