/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.pkg;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.file.FileCmdUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class CreatePackage
extends AbstractCommand {
    public static final String CMD_CREATE_FOLDER = "CREATE_FOLDER";
    public static final String CMD_CREATE_PACKAGE = "CREATE_PACKAGE";
    public static final String COMMAND = "CREATE_PACKAGE";
    private IServerAuth auth;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.auth = auth;
    }

    @Override
    public String getUsage() {
        Object usage = "\nCREATE_PACKAGE";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c CREATE_PACKAGE -a <\"PackageName1\">";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.CREATE_PACKAGE.getDescription() + "\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"CREATE_PACKAGE\"";
        usage = (String)usage + "\n\tARGUMENTS -a\tPackage Name";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c CREATE_PACKAGE -a package01";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        try {
            return this.processCreatePackages(this.params.toArray(new String[0]), is, os);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new CommandResult("Command execution has been interrupted", -99);
        }
    }

    protected CommandResult processCreatePackages(String[] args, SDataInputStream is, SDataOutputStream os) throws IOException, CommandProcessingException, InterruptedException {
        if (args == null || args.length < 1) {
            return new CommandResult("Incorrect parameters!", -1);
        }
        int res = 0;
        StringBuilder output = new StringBuilder();
        GroupTreeObject binaries = FileCmdUtils.getBinaries(is, os, this.auth);
        if (binaries == null) {
            return new CommandResult("Error loading Packages!", -17);
        }
        if (!binaries.hasElements().booleanValue()) {
            return new CommandResult("No Package found on the server!", -17);
        }
        for (String arg : args) {
            List<GroupTreeObject> pkgList;
            String pkgName = arg;
            if (pkgName.startsWith("/")) {
                pkgName = pkgName.substring(1);
            }
            if (pkgName.endsWith("/")) {
                pkgName = pkgName.substring(0, pkgName.length() - 1);
            }
            if ((pkgList = binaries.findGroups(pkgName, "pkg")).isEmpty()) {
                String path = "srv/packages/" + pkgName;
                os.writeUTF(CMD_CREATE_FOLDER);
                os.writeUTF(path);
                String status = is.readUTF();
                if (status.equals("T")) {
                    output.append(path).append("\n");
                    continue;
                }
                output.append("Cannot create Package ").append(path).append("\n");
                ++res;
                continue;
            }
            output.append("Package does already exist ").append(pkgName).append("\n");
            ++res;
        }
        return new CommandResult(output.toString().trim(), res);
    }
}

