/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.pkg;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.Assignment;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class GetAllAssignments
extends AbstractCommand {
    public static final String CMD_GET_ALL_ASSIGNMENTS = "GET_ALL_ASSIGNMENTS";
    public static final String COMMAND = "GET_ALL_ASSIGNMENTS";
    private String separator;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.separator = separator;
    }

    @Override
    public String getUsage() {
        Object usage = "\nGET_ALL_ASSIGNMENTS";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c GET_ALL_ASSIGNMENTS";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.GET_ALL_ASSIGNMENTS.getDescription() + "\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"GET_ALL_ASSIGNMENTS\"";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c GET_ALL_ASSIGNMENTS";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        return this.getAllAssignments(is, os, true);
    }

    protected CommandResult getAllAssignments(SDataInputStream is, SDataOutputStream os, boolean print) throws IOException {
        os.writeUTF("GET_ALL_ASSIGNMENTS");
        int count = 0;
        StringBuilder output = new StringBuilder();
        while (is.readBoolean()) {
            Assignment asn = new Assignment();
            asn.read(is);
            if (!asn.getType().equalsIgnoreCase("pga")) continue;
            if (print) {
                output.append(asn.getAgentID()).append(this.separator).append(asn.getID()).append(this.separator).append(asn.getName()).append("\n");
            }
            ++count;
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            output.append("Getting Assignments successful.\n");
        } else {
            output.append("[ERROR] cannot fetch Assignements ").append(status).append("\n");
        }
        if (count == 0) {
            output.append("No Assignments found!\n");
        }
        return new CommandResult(output.toString());
    }
}

