/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.pkg;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.file.FileCmdUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ListPackages
extends AbstractCommand {
    public static final String CMD_LIST_PACKAGES = "LIST_PACKAGES";
    public static final String COMMAND = "LIST_PACKAGES";
    private IServerAuth auth;

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.auth = auth;
    }

    @Override
    public String getUsage() {
        Object usage = "\nLIST_PACKAGES";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c LIST_PACKAGES [-cc <packageName>]";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.LIST_PACKAGES.getDescription() + "\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"LIST_PACKAGES\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"BinaryPackage name\" (optional)";
        usage = (String)usage + "\n\t\t\tforce:\tIn case of a optional package name specified - prints file pathed.";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c LIST_PACKAGES";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException, CommandProcessingException {
        try {
            return this.processListPackages(this.action, is, os);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new CommandResult("Command execution has been interrupted", -99);
        }
    }

    protected CommandResult processListPackages(String pkgName, SDataInputStream is, SDataOutputStream os) throws IOException, CommandProcessingException, InterruptedException {
        int res = 0;
        StringBuilder output = new StringBuilder();
        GroupTreeObject binaries = FileCmdUtils.getBinaries(is, os, this.auth);
        if (binaries == null) {
            return new CommandResult("Error loading Packages!", -17);
        }
        if (!binaries.hasElements().booleanValue()) {
            return new CommandResult("No Package found on the server!", -17);
        }
        if (pkgName != null && pkgName.length() > 0) {
            List<GroupTreeObject> pkgList = binaries.findGroups(pkgName, "pkg");
            if (pkgList.isEmpty()) {
                return new CommandResult("Package not found: " + pkgName, 1);
            }
            List<GroupTreeObject> children = pkgList.get(0).getAllElements();
            if (children.isEmpty()) {
                return new CommandResult("Package " + pkgName + " does not contain any files.", 1);
            }
            for (GroupTreeObject child : children) {
                String path = child.getPath();
                path = path.replace("/root/Packages/", "");
                output.append(path).append("\n");
            }
        } else {
            List<GroupTreeObject> pkgList = binaries.getAllElements();
            int countFound = 0;
            for (GroupTreeObject gto : pkgList) {
                if (!"pkg".equals(gto.getType())) continue;
                String path = gto.getName();
                path = path.replace("/root/Packages/", "");
                output.append(path).append("\n");
                ++countFound;
            }
            if (countFound == 0) {
                output.append("Packages not found");
                res = 1;
            }
        }
        return new CommandResult(output.toString().trim(), res);
    }
}

