/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.pol;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.StrUtils;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.pol.PolicyCommandUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExportPolicies
extends AbstractCommand {
    public static final String CMD_EXPORT_POLICIES = "EXPORT_POLICIES";
    public static final String COMMAND = "EXPORT_POLICIES";
    private StrUtils strUtils = new StrUtils();

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
    }

    @Override
    public String getUsage() {
        Object usage = "\nEXPORT_POLICIES";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c EXPORT_POLICIES -cc policy -a <\"ExportDirectory\"> -a <\"PolicyType\"> -a <\"PolicyName\"> [-a <argument4> -a <argument5>] ...";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c EXPORT_POLICIES -cc group -a <\"ExportDirectory\"> -a <\"PolicyGroupPath\">";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.EXPORT_POLICIES.getDescription() + "\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"EXPORT_POLICIES\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"policy\"|\"group\"";
        usage = (String)usage + "\n\t\t\tpolicy:\tExport single Policies";
        usage = (String)usage + "\n\t\t\tgroup:\tExport all policies inside the given Policy Group.";
        usage = (String)usage + "\n\tARGUMENTS -a\t(1) Arguments for the option \"-cc policy\":";
        usage = (String)usage + "\n\t\t\t1.arg - export directory.";
        usage = (String)usage + "\n\t\t\tall further arguments must be a pair of type and name:";
        usage = (String)usage + "\n\t\t\t2.arg - Policy type (mon|msg)";
        usage = (String)usage + "\n\t\t\t3.arg - Policy name";
        usage = (String)usage + "\n\t\t\t... ";
        usage = (String)usage + "\n\t\t\t(2) Arguments for the option \"group\":";
        usage = (String)usage + "\n\t\t\t1.arg - export directory.";
        usage = (String)usage + "\n\t\t\t2.arg - PolicyGroup with path.";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c EXPORT_POLICIES -cc policy -a Policies01/export -a mon -a BOOM_Ping -a msg -a hpuxOSMPI_Syslogs";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c EXPORT_POLICIES -cc group -a Policies01/export -a BOOM/Agentless/";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException {
        try {
            return this.processExportPolicy(this.getAction(), this.getParams().toArray(new String[0]), is, os);
        }
        catch (CommandProcessingException e) {
            return new CommandResult(e.getMessage(), e.getCode());
        }
    }

    protected CommandResult processExportPolicy(String action, String[] args, SDataInputStream is, SDataOutputStream os) throws InvalidInputException, CommandProcessingException, IOException {
        if (action == null || action.length() == 0 || args == null || action.equals("policy") && args.length % 2 == 0 || action.equals("group") && args.length % 2 != 0) {
            throw new InvalidInputException("Incorrect parameters!");
        }
        int res = 0;
        StringBuilder output = new StringBuilder();
        if (action.equals("policy")) {
            if (args.length < 3) {
                throw new InvalidInputException("Incorrect parameters!");
            }
            String localDir = args[0];
            localDir = this.strUtils.removeQuotes(localDir);
            for (int i = 1; i < args.length; i += 2) {
                String objectType = args[i];
                String objectName = args[i + 1];
                objectType = this.strUtils.removeQuotes(objectType);
                objectName = this.strUtils.removeQuotes(objectName);
                if (!objectType.equals("mon") && !objectType.equals("msg")) {
                    throw new InvalidInputException("Invalid type: " + objectType + " for Policy " + objectName + "\nIncorrect parameters!");
                }
                CommandResult fileRequestResult = this.requestFile(is, os, localDir, objectType, objectName);
                output.append(fileRequestResult.getOutput()).append("\n");
                res += fileRequestResult.getCode();
            }
        } else if (action.equals("group")) {
            if (args.length != 2) {
                throw new InvalidInputException("Incorrect parameters!");
            }
            String localDir = args[0];
            File ld = new File(localDir = this.strUtils.removeQuotes(localDir));
            if (!ld.exists() && !ld.mkdirs()) {
                throw new CommandProcessingException("Can not create local directory: " + localDir, -15);
            }
            try (ByteArrayOutputStream outputStream = PolicyCommandUtils.getPolicies(is, os);){
                GroupTreeObject policies = PolicyCommandUtils.parsePolicies(outputStream);
                List<GroupTreeObject> allPolicies = policies.getAllElements();
                if (allPolicies.isEmpty()) {
                    throw new CommandProcessingException("No Policies found!", -11);
                }
                for (int i = 1; i < args.length; ++i) {
                    GroupTreeObject groupGTO;
                    Object group = args[i];
                    if (!((String)(group = this.strUtils.removeQuotes((String)group))).startsWith("/root/Policies")) {
                        if (((String)group).charAt(0) != '/') {
                            group = "/" + (String)group;
                        }
                        group = "/root/Policies" + (String)group;
                    }
                    if (((String)group).endsWith("/")) {
                        group = ((String)group).substring(0, ((String)group).length() - 1);
                    }
                    if ((groupGTO = policies.searchPath((String)group, "")) == null) {
                        groupGTO = policies.searchPath((String)group, "toplevel");
                    }
                    if (groupGTO == null) {
                        output.append("Policy Group not found: ").append((String)group).append("\n");
                        ++res;
                        continue;
                    }
                    output.append((String)group).append("\n");
                    List<GroupTreeObject> elems = groupGTO.getAllElements();
                    if (elems.isEmpty()) {
                        output.append("Empty Policy Group ").append((String)group).append("\n");
                        continue;
                    }
                    ArrayList<GroupTreeObjectLast> policyGTOLs = new ArrayList<GroupTreeObjectLast>();
                    for (GroupTreeObject gto : elems) {
                        if (!(gto instanceof GroupTreeObjectLast)) continue;
                        policyGTOLs.add((GroupTreeObjectLast)gto);
                    }
                    if (policyGTOLs.isEmpty()) {
                        output.append("Empty Policy Group ").append((String)group).append("\n");
                        continue;
                    }
                    output.append(policyGTOLs.size()).append(" Policies:").append("\n");
                    for (GroupTreeObjectLast gtol : policyGTOLs) {
                        CommandResult fileRequestResult = this.requestFile(is, os, localDir, gtol.getType(), gtol.getName());
                        output.append(fileRequestResult.getOutput()).append("\n");
                        res += fileRequestResult.getCode();
                    }
                }
            }
        } else {
            throw new InvalidInputException("Invalid option " + action);
        }
        return new CommandResult(output.toString().trim(), res);
    }

    protected CommandResult requestFile(SDataInputStream is, SDataOutputStream os, String localDir, String objectType, String objectName) throws IOException {
        int res = 0;
        Object output = "";
        os.writeUTF("GETFILE");
        os.writeUTF(objectName);
        os.writeUTF(objectType);
        String filename = is.readUTF();
        if (filename.startsWith("NoFileFound_for_")) {
            output = (String)output + "File not found: " + objectName;
            is.readLong();
            is.readUTF();
            ++res;
        } else {
            String status;
            long size;
            block16: {
                size = is.readLong();
                File wFile = null;
                if (size >= 0L) {
                    String addDir = "";
                    if (filename.indexOf(47) != -1) {
                        addDir = filename.substring(0, filename.lastIndexOf(47));
                        filename = filename.substring(filename.lastIndexOf(47) + 1);
                        if (addDir.startsWith("/")) {
                            addDir = addDir.substring(1);
                        }
                    }
                    if (!((String)localDir).endsWith("/") && !((String)localDir).endsWith("\\")) {
                        localDir = (String)localDir + "/";
                    }
                    try {
                        File dirF = new File((String)localDir + addDir);
                        if (!dirF.exists()) {
                            Files.createDirectories(dirF.toPath(), new FileAttribute[0]);
                        }
                        wFile = new File(dirF, filename);
                        if (size > 0L) {
                            is.readFile(wFile.getCanonicalPath());
                            break block16;
                        }
                        Files.deleteIfExists(wFile.toPath());
                        Files.createFile(wFile.toPath(), new FileAttribute[0]);
                    }
                    catch (Throwable e) {
                        output = (String)output + "Error writing local file: " + filename + "\n";
                        ++res;
                    }
                } else {
                    output = (String)output + "File not found: " + filename + "\n";
                    ++res;
                }
            }
            if ((status = is.readUTF()).equals("T")) {
                if (size < 0L) {
                    output = (String)output + "File not found: " + filename + "\n";
                    ++res;
                } else {
                    output = (String)output + filename + "\n";
                }
            } else if (status.equals("F") && size < 0L) {
                output = (String)output + "File not found: " + filename + "\n";
                ++res;
            }
        }
        return new CommandResult(((String)output).trim(), res);
    }
}

