/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.pol;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.in.ScGetAgentPolicies;
import com.blixx.shared.PolicyDeployed;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GetAgentPolicies
extends AbstractCommand {
    public static final String CMD_GET_AGENT_POLICIES = "GET_AGENT_POLICIES";
    public static final String COMMAND = "GET_AGENT_POLICIES";
    private String separator = "\t";

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.separator = separator;
    }

    @Override
    public String getUsage() {
        Object usage = "\nGET_AGENT_POLICIES";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c GET_AGENT_POLICIES -cc <agentID>";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.GET_AGENT_POLICIES.getDescription() + "\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"GET_AGENT_POLICIES\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"agent ID\" (required)";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c GET_AGENT_POLICIES -cc 8c5a4152-6928-4846-9e20-8ded4230589b";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException {
        int res = 0;
        StringBuilder output = new StringBuilder();
        ScGetAgentPolicies sc = new ScGetAgentPolicies(null, this.action);
        try {
            sc.runDirect(is, os);
            if (sc.isSuccess()) {
                if (sc.getResultObject().isEmpty()) {
                    output.append("No policies deployed on ").append(this.action);
                } else {
                    Iterator iterator = sc.getResultObject().iterator();
                    while (iterator.hasNext()) {
                        PolicyDeployed pd = (PolicyDeployed)iterator.next();
                        String sb = pd.getPolicyName() + this.separator + pd.getPolicyType() + this.separator + pd.getPolicyVersionAgent() + this.separator + pd.getPolicyVersionServer() + this.separator + (pd.isPolicyDisabled() ? "(disabled)" : "(enabled)");
                        output.append(sb).append("\n");
                    }
                }
            } else {
                output = new StringBuilder("Failed to get policies from agent: " + this.action);
                res = -99;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new CommandResult(e.getMessage(), res);
        }
        return new CommandResult(output.toString().trim(), res);
    }
}

