/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.pol;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.StrUtils;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.cmds.pol.PolicyCommandUtils;
import com.boom.server.cli.exceptions.CommandProcessingException;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class GetPolicies
extends AbstractCommand {
    private static final String CMD_GET_POLICY_VERSIONS = "GET_POLICY_VERSIONS";
    public static final String CMD_GETPOLICIES = "GETPOLICIES";
    public static final String COMMAND = "GETPOLICIES";
    public static final String ROOT_POLICIES = "/root/Policies";
    private StrUtils strUtils = new StrUtils();

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
    }

    @Override
    public String getUsage() {
        Object usage = "\nGETPOLICIES";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c GETPOLICIES -cc <option> [-a <argument1>] [-a <argument2>] ...";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.GETPOLICIES.getDescription() + "\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"GETPOLICIES\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"print\"|\"list\"|\"listnames\"|\"listpaths\"|\"checkname\"|\"checkpath\" (required)";
        usage = (String)usage + "\n\t\t\tprint:\t\tprint file policyGroups.xml";
        usage = (String)usage + "\n\t\t\tlist:\t\tlist Policy names with path, type and version";
        usage = (String)usage + "\n\t\t\tlistnames:\tlist Policy names only";
        usage = (String)usage + "\n\t\t\tlistpaths:\tist Policy paths only";
        usage = (String)usage + "\n\t\t\tcheckname:\tcheck if Policy does exist";
        usage = (String)usage + "\n\t\t\tcheckpath:\tcheck if Policy path does exist";
        usage = (String)usage + "\n\tARGUMENTS -a\t\"name\"|\"path\"";
        usage = (String)usage + "\n\tEXAMPLES\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETPOLICIES -cc list";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETPOLICIES -cc listnames";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETPOLICIES -cc listpaths";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETPOLICIES -cc checkname -a BOOM_Ping -a JMX_Memory";
        usage = (String)usage + "\n\t\t\tjava -jar boom_cli.jar -f boom_cli.cfg -c GETPOLICIES -cc checkpath -a BOOM/BOOM_Ping -a BOOM/Linux/linuxOSMPI_Disk_usage";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException {
        return this.processGetPolicies(this.getAction(), this.getParams().toArray(new String[0]), is, os);
    }

    protected CommandResult processGetPolicies(String action, String[] args, SDataInputStream is, SDataOutputStream os) throws IOException, InvalidInputException {
        StringBuilder output = new StringBuilder();
        int res = 0;
        if (action == null || action.length() == 0) {
            throw new InvalidInputException("Incorrect parameters!");
        }
        if (action.equalsIgnoreCase("print")) {
            try (ByteArrayOutputStream baos = PolicyCommandUtils.getPolicies(is, os);){
                output = new StringBuilder(baos.toString());
            }
            catch (CommandProcessingException e) {
                output = new StringBuilder(e.getMessage());
                res = e.getCode();
            }
        } else {
            os.writeUTF(CMD_GET_POLICY_VERSIONS);
            String pList = is.readUTF();
            if (pList.length() == 0) {
                output = new StringBuilder("No Policies found!");
                res = -11;
            } else if (action.startsWith("list")) {
                String[] policies = pList.split("\n");
                if (!(action.equalsIgnoreCase("list") || action.equalsIgnoreCase("listnames") || action.equalsIgnoreCase("listpaths"))) {
                    output = new StringBuilder("Invalid option: " + action);
                    res = -1;
                } else {
                    for (String polDetails : policies) {
                        String[] elem;
                        if (action.equalsIgnoreCase("list")) {
                            output.append(polDetails).append("\n");
                            continue;
                        }
                        if (action.equalsIgnoreCase("listnames")) {
                            elem = GetPolicies.splitPolicyDetails(polDetails);
                            if (elem == null) continue;
                            String name = elem[0].substring(elem[0].lastIndexOf(47) + 1, elem[0].length());
                            output.append(name).append("\n");
                            continue;
                        }
                        if (!action.equalsIgnoreCase("listpaths") || (elem = GetPolicies.splitPolicyDetails(polDetails)) == null) continue;
                        output.append(elem[0]).append("\n");
                    }
                }
            } else if (action.equalsIgnoreCase("checkpath")) {
                if (args == null || args.length == 0) {
                    throw new InvalidInputException("Incorrect parameters!");
                }
                String[] policies = pList.split("\n");
                for (String arg : args) {
                    Object path = arg;
                    if (!((String)(path = this.strUtils.removeQuotes((String)path))).startsWith(ROOT_POLICIES)) {
                        if (!((String)path).startsWith("/")) {
                            path = "/" + (String)path;
                        }
                        path = ROOT_POLICIES + (String)path;
                    }
                    boolean found = false;
                    for (String polDetails : policies) {
                        String[] elem = polDetails.split(" ");
                        String foundPath = elem[0];
                        if (!((String)path).equals(foundPath)) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        output.append((String)path).append("\n");
                        continue;
                    }
                    output.append("Invalid path: ").append((String)path).append("\n");
                    ++res;
                }
            } else if (action.equalsIgnoreCase("checkname")) {
                if (args == null || args.length == 0) {
                    throw new InvalidInputException("Incorrect parameters!");
                }
                String[] policies = pList.split("\n");
                String[] stringArray = args;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String arg;
                    String policyName = arg = stringArray[i];
                    policyName = this.strUtils.removeQuotes(policyName);
                    boolean found = false;
                    for (String polDetails : policies) {
                        String[] elem = polDetails.split(" ");
                        String foundName = elem[0].substring(elem[0].lastIndexOf(47) + 1, elem[0].length());
                        if (!policyName.equals(foundName)) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        output.append(policyName).append("\n");
                        continue;
                    }
                    output.append("Invalid name ").append(policyName).append("\n");
                    ++res;
                }
            } else {
                throw new InvalidInputException("Incorrect parameters!");
            }
        }
        return new CommandResult(output.toString().trim(), res);
    }

    protected static String[] splitPolicyDetails(String polDetails) {
        String[] elem = new String[3];
        String[] split = polDetails.split(" ");
        if (split.length == 3) {
            elem = split;
        } else if (split.length > 3) {
            int size = split.length;
            elem[2] = split[size - 1];
            elem[1] = split[size - 2];
            StringBuilder tmp = new StringBuilder();
            for (int ii = size - 3; ii > -1; --ii) {
                tmp.insert(0, split[ii]);
            }
            elem[0] = tmp.toString();
        } else {
            elem = null;
        }
        return elem;
    }
}

