/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.pol;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.StrUtils;
import com.boom.server.cli.cmds.AbstractCommand;
import com.boom.server.cli.cmds.CommandResult;
import com.boom.server.cli.cmds.ListOfCommands;
import com.boom.server.cli.exceptions.InvalidInputException;
import com.boom.server.cli.exceptions.ParameterUsageException;
import com.boom.server.cli.exceptions.UnknownActionException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportPolicies
extends AbstractCommand {
    public static final String COMMAND = "IMPORT_POLICIES";
    private static final String CMD_UPDATEPOLICY = "UPDATEPOLICY";
    private static final String ROOT_POLICIES = "/root/Policies";
    public String separator = "\t";
    private static final Pattern POLICY_VERSION_PATTERN = Pattern.compile(".*POLICY_VERSION.*(\\d+\\.\\d+)\\s*");
    private static final StrUtils stringUtils = new StrUtils();
    private static final String CMD_GET_POLICY_VERSIONS = "GET_POLICY_VERSIONS";
    private String output = "";

    @Override
    public void initialize(String command, String action, List<String> params, Map<String, String> namedParameters, String separator, IServerAuth auth) {
        this.command = command;
        this.action = action;
        this.params = params;
        this.separator = separator;
    }

    @Override
    public String getUsage() {
        Object usage = "\nIMPORT_POLICIES";
        usage = (String)usage + "\n\tjava -jar boom_cli.jar -f <conffile> -c IMPORT_POLICIES [-cc force] -a <\"SourceDirectory\">";
        usage = (String)usage + "\n\tDESCRIPTION\t" + ListOfCommands.IMPORT_POLICIES.getDescription() + "\n";
        usage = (String)usage + "\n\tCOMMAND -c\t\"IMPORT_POLICIES\"";
        usage = (String)usage + "\n\tOPTION -cc\t\"force\"";
        usage = (String)usage + "\n\t\t\tforce:\tIn case of a version conflict, the Policy will be imported with a higher version.";
        usage = (String)usage + "\n\t\t\t\t\tWithout this option all Policies with version conflicts will be ignored.";
        usage = (String)usage + "\n\tARGUMENTS -a\tLocal directory that contains all Policy files for import.";
        return usage;
    }

    @Override
    public CommandResult executeCommand(SDataInputStream is, SDataOutputStream os) throws UnknownActionException, IOException, ParameterUsageException, InvalidInputException {
        return this.processImportPolicy(this.getAction(), this.getParams().toArray(new String[0]), is, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommandResult processImportPolicy(String action, String[] args, SDataInputStream is, SDataOutputStream os) throws InvalidInputException, IOException {
        if (args == null || args.length != 1) {
            throw new InvalidInputException("Incorrect parameters!");
        }
        int res = 0;
        boolean forceImport = false;
        if (action != null) {
            if (action.equalsIgnoreCase("force")) {
                forceImport = true;
            } else {
                throw new InvalidInputException("Invalid Option: " + action);
            }
        }
        ArrayList<File> localDirectories = new ArrayList<File>();
        for (String arg : args) {
            String localDir = stringUtils.removeQuotes(arg);
            File dir = new File(localDir);
            if (!dir.exists()) {
                this.printMsg("Directory not found: " + localDir);
                continue;
            }
            if (!dir.canRead()) {
                this.printMsg("Cannot read directory: " + localDir);
                continue;
            }
            localDirectories.add(dir);
        }
        if (localDirectories.isEmpty()) {
            return new CommandResult("Invalid directories!", -8);
        }
        os.writeUTF(CMD_GET_POLICY_VERSIONS);
        String pols = is.readUTF();
        if (pols.length() == 0) {
            return new CommandResult(" No Policies found on the server!", -11);
        }
        String[] srvPolicies = pols.split("\n");
        for (File dir : localDirectories) {
            List<File> policies4Import = ImportPolicies.getLocalPolicyFiles(dir);
            if (policies4Import == null || policies4Import.isEmpty()) {
                this.printMsg("No Policies found in " + dir.getName());
                continue;
            }
            for (File file : policies4Import) {
                int value;
                StringBuilder sb = new StringBuilder();
                String[] params = ImportPolicies.getPolicyParams(file, srvPolicies);
                if (params == null || params.length != 5) {
                    ++res;
                    sb.append(file.getName()).append(this.separator).append("error").append(this.separator).append("local=").append("X").append(this.separator).append("srv=").append("X").append(this.separator).append("imported=").append("X");
                    this.printMsg(sb.toString());
                    continue;
                }
                String srvVersion = params[4];
                String localVersion = this.getLocalPolicyVersion(file);
                String importedVersion = "X";
                if (localVersion == null) {
                    ++res;
                    localVersion = "X";
                    sb.append(file.getName()).append(this.separator).append("error").append(this.separator).append("local=").append(localVersion).append(this.separator).append("srv=").append("X").append(this.separator).append("imported=").append(importedVersion);
                    this.printMsg(sb.toString());
                    continue;
                }
                if (srvVersion.equals("")) {
                    srvVersion = "X";
                    value = this.uploadPolicy(params, is, os);
                    if (value < 0) {
                        ++res;
                        importedVersion = "X";
                        sb.append(file.getName()).append(this.separator).append("error").append(this.separator).append("local=").append(localVersion).append(this.separator).append("srv=").append(srvVersion).append(this.separator).append("imported=").append(importedVersion);
                    } else {
                        importedVersion = localVersion;
                        sb.append(file.getName()).append(this.separator).append("ok").append(this.separator).append("local=").append(localVersion).append(this.separator).append("srv=").append(srvVersion).append(this.separator).append("imported=").append(importedVersion);
                    }
                    this.printMsg(sb.toString());
                    continue;
                }
                if (ImportPolicies.getVersionAsInt(localVersion) <= ImportPolicies.getVersionAsInt(srvVersion)) {
                    if (forceImport) {
                        importedVersion = this.getNextVersion(srvVersion);
                        int resUpdate = this.updatePolicyVersion(file, importedVersion);
                        if (resUpdate == 0) {
                            params[2] = params[2] + "_tmp";
                            try {
                                int value2 = this.uploadPolicy(params, is, os);
                                if (value2 < 0) {
                                    ++res;
                                    importedVersion = "X";
                                    sb.append(file.getName()).append(this.separator).append("error").append(this.separator).append("local=").append(localVersion).append(this.separator).append("srv=").append(srvVersion).append(this.separator).append("imported=").append(importedVersion);
                                }
                                sb.append(file.getName()).append(this.separator).append("ok").append(this.separator).append("local=").append(localVersion).append(this.separator).append("srv=").append(srvVersion).append(this.separator).append("imported=").append(importedVersion);
                            }
                            finally {
                                File tmpfile = new File(params[2] + "_tmp");
                                tmpfile.deleteOnExit();
                                params[2] = params[2].substring(0, params[2].length() - 4);
                            }
                        } else {
                            ++res;
                            importedVersion = "X";
                            sb.append(file.getName()).append(this.separator).append("error").append(this.separator).append("local=").append(localVersion).append(this.separator).append("srv=").append(srvVersion).append(this.separator).append("imported=").append(importedVersion);
                        }
                    } else {
                        ++res;
                        importedVersion = "X";
                        sb.append(file.getName()).append(this.separator).append("skipped").append(this.separator).append("local=").append(localVersion).append(this.separator).append("srv=").append(srvVersion).append(this.separator).append("imported=").append(importedVersion);
                    }
                    this.printMsg(sb.toString());
                    continue;
                }
                importedVersion = localVersion;
                value = this.uploadPolicy(params, is, os);
                if (value < 0) {
                    ++res;
                    importedVersion = "X";
                    sb.append(file.getName()).append(this.separator).append("error").append(this.separator).append("local=").append(localVersion).append(this.separator).append("srv=").append(srvVersion).append(this.separator).append("imported=").append(importedVersion);
                } else {
                    sb.append(file.getName()).append(this.separator).append("ok").append(this.separator).append("local=").append(localVersion).append(this.separator).append("srv=").append(srvVersion).append(this.separator).append("imported=").append(importedVersion);
                }
                this.printMsg(sb.toString());
            }
        }
        return new CommandResult(this.output, res);
    }

    protected static String[] getPolicyParams(File policy, String[] srvPolicies) {
        String localPolName;
        String localPolType;
        String fileName = policy.getName();
        if (fileName.endsWith(".mon.xml")) {
            localPolType = "mon";
            split = fileName.split(".mon.xml");
            localPolName = split[0];
        } else if (policy.getName().endsWith(".msg.xml")) {
            localPolType = "msg";
            split = fileName.split(".msg.xml");
            localPolName = split[0];
        } else {
            return null;
        }
        String[] params = null;
        for (String polDetails : srvPolicies) {
            String[] elem = polDetails.split(" ");
            String srvPolPath = elem[0].substring(0, elem[0].lastIndexOf(47));
            String srvPolName = elem[0].substring(elem[0].lastIndexOf(47) + 1, elem[0].length());
            String srvPolType = elem[1];
            String srvPolVersion = elem[2];
            if (!srvPolName.equals(localPolName) || !srvPolType.equals(localPolType)) continue;
            params = new String[]{srvPolName, srvPolType, policy.getAbsolutePath(), srvPolPath, srvPolVersion};
            break;
        }
        if (params == null) {
            params = new String[]{localPolName, localPolType, policy.getAbsolutePath(), ROOT_POLICIES, ""};
        }
        return params;
    }

    public static int getVersionAsInt(String version) {
        int pos = version.indexOf(".");
        int ver = 1;
        if (pos != -1) {
            String major = version.substring(0, pos);
            String minor = version.substring(pos + 1);
            ver = Integer.parseInt(major) * 100 + Integer.parseInt(minor);
        }
        return ver;
    }

    public String getNextVersion(String version) {
        int old = ImportPolicies.getVersionAsInt(version);
        int major = ++old / 100;
        int minor = old - major * 100;
        return major + "." + minor;
    }

    protected String getLocalPolicyVersion(File file) {
        String localVersion = null;
        try (FileReader fr = new FileReader(file);
             BufferedReader br = new BufferedReader(fr);){
            boolean eof = false;
            while (!eof) {
                String line = br.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                Matcher m = POLICY_VERSION_PATTERN.matcher(line);
                if (!m.matches()) continue;
                localVersion = m.group(1);
                break;
            }
        }
        catch (Exception e) {
            this.printMsg(e.getMessage());
        }
        return localVersion;
    }

    private void printMsg(String msg) {
        this.output = this.output + msg + "\n";
    }

    protected int uploadPolicy(String[] params, SDataInputStream is, SDataOutputStream os) throws IOException {
        String objectName = params[0];
        String objectType = params[1];
        String file = params[2];
        String treePath = params[3];
        os.writeUTF(CMD_UPDATEPOLICY);
        os.writeUTF(objectName);
        os.writeUTF(objectType);
        File f = new File(file);
        long size = f.length();
        os.writeUTF(f.getName());
        os.writeUTF(treePath);
        os.writeLong(size);
        FileInputStream fis = new FileInputStream(f);
        os.writeFile(fis);
        fis.close();
        String result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("F")) {
            this.printMsg("[ERROR] pushing file " + objectName + ": \n" + result);
            return -9;
        }
        this.printMsg("File pushed: " + objectName + "  " + status);
        return 0;
    }

    protected int updatePolicyVersion(File file, String newVersion) {
        int res = 0;
        try (FileReader fr = new FileReader(file);
             BufferedReader br = new BufferedReader(fr);){
            StringBuilder sb = new StringBuilder();
            boolean eof = false;
            while (!eof) {
                String line = br.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                if (line.contains("POLICY_VERSION")) {
                    String currVersion = line.substring(line.lastIndexOf(".") - 1, line.length());
                    line = line.replace(currVersion, newVersion);
                }
                sb.append(line).append("\r\n");
            }
            try (FileWriter fw = new FileWriter(String.valueOf(file) + "_tmp");
                 BufferedWriter bw = new BufferedWriter(fw);){
                bw.write(sb.toString());
            }
        }
        catch (Exception e) {
            res = 1;
            this.printMsg(e.getMessage());
        }
        return res;
    }

    protected static List<File> getLocalPolicyFiles(File dir) {
        File[] list = dir.listFiles(new XMLFileFilter());
        if (list == null) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<File> fileListReadErr = new ArrayList<File>();
        for (File file : list) {
            if (file.canRead()) {
                fileList.add(file);
                continue;
            }
            fileListReadErr.add(file);
        }
        return fileList;
    }

    private static class XMLFileFilter
    implements FileFilter {
        private XMLFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().toLowerCase().endsWith(".xml");
        }
    }
}

