/*
 * Decompiled with CFR 0.152.
 */
package com.boom.server.cli.cmds.pol;

import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.XMLTree;
import com.boom.server.cli.exceptions.CommandProcessingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PolicyCommandUtils {
    public static final String ROOT_POLICIES = "/root/Policies";
    public static final String CMD_GETFILE = "GETFILE";
    private static final String OBJECT_NAME = "srv/policies/policyGroups.xml";

    private PolicyCommandUtils() {
    }

    public static ByteArrayOutputStream getPolicies(SDataInputStream is, SDataOutputStream os) throws IOException, CommandProcessingException {
        String objectType = "file";
        os.writeUTF(CMD_GETFILE);
        os.writeUTF(OBJECT_NAME);
        os.writeUTF(objectType);
        is.readUTF();
        long size = is.readLong();
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)size);
        if (size >= 0L) {
            try {
                int blockSize = -1;
                byte[] inArr = new byte[1024];
                while ((blockSize = is.readInt()) != -1) {
                    if (blockSize != 1024) {
                        inArr = new byte[blockSize];
                    }
                    is.readFully(inArr);
                    baos.write(inArr);
                }
            }
            catch (Throwable e1) {
                throw new CommandProcessingException("Error writing local file: srv/policies/policyGroups.xml", e1, -8);
            }
        } else {
            is.readUTF();
            throw new CommandProcessingException("Requested file not found: srv/policies/policyGroups.xml", -8);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            // empty if block
        }
        return baos;
    }

    public static GroupTreeObject parsePolicies(ByteArrayOutputStream baos) throws CommandProcessingException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            XMLTree xt = new XMLTree();
            return xt.parseXML(bais, true);
        }
        catch (Throwable e) {
            throw new CommandProcessingException("Error parsing file: srv/policies/policyGroups.xml", e, -8);
        }
    }
}

