/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc.in;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.log.RTLogger;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ScGetAssigned
extends ServerClient {
    public ScGetAssigned(IServerAuth auth, String agentID) {
        super(auth);
        this.setCommand("GETASSIGNED", agentID);
    }

    @Override
    public List<AssignedElement> getResultObject() {
        return (List)this.m_result;
    }

    @Override
    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        this.processAssigned(is, os);
    }

    public void processAssigned(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        try {
            AssignedElement ae;
            String version;
            String monitor;
            int i;
            os.writeUTF(this.m_command);
            os.writeUTF(this.m_action);
            String type = is.readUTF();
            if (type.equals("F")) {
                return;
            }
            ArrayList<AssignedElement> assigned = new ArrayList<AssignedElement>();
            int size = is.readInt();
            for (i = 0; i < size; ++i) {
                monitor = is.readUTF();
                version = is.readUTF();
                ae = new AssignedElement(this);
                ae.setName(monitor);
                ae.setType("mon");
                ae.setVersion(version);
                assigned.add(ae);
            }
            type = is.readUTF();
            size = is.readInt();
            for (i = 0; i < size; ++i) {
                monitor = is.readUTF();
                version = is.readUTF();
                ae = new AssignedElement(this);
                ae.setName(monitor);
                ae.setType("msg");
                ae.setVersion(version);
                assigned.add(ae);
            }
            type = is.readUTF();
            size = is.readInt();
            for (i = 0; i < size; ++i) {
                String assignmentName = is.readUTF();
                String typeOfAssignment = is.readUTF();
                String version2 = is.readUTF();
                int deploymentStatus = is.readInt();
                AssignedElement ae2 = new AssignedElement(this);
                ae2.setName(assignmentName);
                ae2.setType(typeOfAssignment);
                ae2.setDeploymentStatus(deploymentStatus);
                if (version2 != null && version2.length() > 0) {
                    ae2.setVersion(version2);
                }
                assigned.add(ae2);
            }
            String status = is.readUTF();
            if (status.equals("T")) {
                this.isOKFinished = true;
            }
            this.m_result = assigned;
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "PPA3946", e);
        }
        catch (Throwable e) {
            RTLogger.print(5, "PPA3546", e);
        }
    }

    public class AssignedElement {
        private String m_parentName;
        private String m_name;
        private String m_type;
        private String m_version;
        private int m_deploymentStatus;

        public AssignedElement(ScGetAssigned this$0) {
        }

        public boolean isSingleAssignemnt() {
            return this.m_parentName == null;
        }

        public String getParentName() {
            return this.m_parentName;
        }

        public void setParentName(String parentName) {
            this.m_parentName = parentName;
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public String getType() {
            return this.m_type;
        }

        public void setType(String type) {
            this.m_type = type;
        }

        public String getVersion() {
            return this.m_version;
        }

        public void setVersion(String version) {
            this.m_version = version;
        }

        public int getDeploymentStatus() {
            return this.m_deploymentStatus;
        }

        public void setDeploymentStatus(int deploymentStatus) {
            this.m_deploymentStatus = deploymentStatus;
        }
    }
}

