/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc.in;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.IAgentCMRepository;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.Map;

public class ScSetAgentAttribute
extends ServerClient {
    String m_agentID = null;
    String m_attribute = null;
    String m_value = null;

    public ScSetAgentAttribute(IServerAuth auth, String agentID, String attribute, String value) {
        super(auth);
        this.setCommand("SET_AGENT_ATTRIBUTE");
        this.m_agentID = agentID;
        this.m_attribute = attribute;
        this.m_value = value;
    }

    @Override
    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_agentID);
        os.writeUTF(this.m_attribute);
        os.writeUTF(this.m_value);
        String res = is.readUTF();
        if ("T".equals(res)) {
            this.isOKFinished = true;
        } else {
            this.m_result = res;
            this.m_lastException = new Exception(res);
        }
    }

    public boolean runCommandOnServer(SDataInputStream is, SDataOutputStream os, IAgentCMRepository rep, Map<String, String> labels) throws IOException, InterruptedException {
        Object result = "";
        String agentID = is.readUTF();
        String attribute = is.readUTF();
        String value = is.readUTF();
        String attributeResolved = attribute;
        if (!AgentCardCM.isKnownAttribute(attributeResolved)) {
            attributeResolved = labels.get(attributeResolved);
        }
        if (attributeResolved == null) {
            result = "Unknown attribute: " + attribute;
        } else {
            try {
                Object valueObj = AgentCardCM.getValue(attributeResolved, value);
                AgentCardCM acm = rep.getAgentCardCM(agentID);
                if (acm == null) {
                    acm = new AgentCardCM(agentID);
                }
                acm.add(attributeResolved, valueObj);
                rep.saveAgentCardCM(acm);
                result = "T";
            }
            catch (Throwable e) {
                result = "Error setting attribute " + attribute + ": for agentID=" + agentID + " " + e.getMessage();
            }
        }
        os.writeUTF((String)result);
        return "T".equals(result);
    }
}

