/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.log;

import com.blixx.log.LoggerMain;
import com.blixx.shared.utils.FileUtils;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class RTLogger
implements Logger {
    private static final String LOG4J2_CONFIG_FILE = "log4j2.xml";
    private static final String LOG4J2_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Configuration  monitorInterval=\"5\" status=\"WARN\">\n   <Appenders>\n      <Console name=\"Console\" target=\"SYSTEM_ERR\">\n           <PatternLayout pattern=\"%d{yyMMdd HH:mm:ss.SSS} %t %X{lvl} %m%n\"/>\n      </Console>\n      <RollingFile name=\"rollingFile\" fileName=\"logs/PREFIX.log\" filePattern=\"logs/PREFIX_%d{yyyy-MM-dd}_%i.log\">\n            <PatternLayout pattern=\"%d{yyMMdd HH:mm:ss.SSS} %t %X{lvl} %m%n\"/>\n            <Policies>\n                <OnStartupTriggeringPolicy />\n                <TimeBasedTriggeringPolicy />\n                <SizeBasedTriggeringPolicy size=\"100 MB\"/>\n            </Policies>\n            <DefaultRolloverStrategy max=\"15\">\n                <Delete basePath=\"logs/\" maxDepth=\"1\">\n                    <IfFileName glob=\"PREFIX_*.log\">\n                        <IfLastModified age=\"10d\">\n                            <IfAny>\n                                <IfAccumulatedFileSize exceeds=\"100 GB\" />\n                                <IfAccumulatedFileCount exceeds=\"15\" />\n                            </IfAny>\n                        </IfLastModified>\n                    </IfFileName>\n                </Delete>\n            </DefaultRolloverStrategy>\n        </RollingFile>\n   </Appenders>\n   <Loggers>\n      <Logger name=\"org.eclipse.jetty\" level=\"WARN\" additivity=\"true\"/>\n      <Logger name=\"com.boom.netty.client\" level=\"INFO\" additivity=\"true\"/>\n      <Logger name=\"com.boom.netty.service.file.FileReceiveHandler\" level=\"DEBUG\" additivity=\"true\"/>\n      <Logger name=\"com.boom.netty.service.file.FileSendHandler\" level=\"DEBUG\" additivity=\"true\"/>\n      <Root level=\"INFO\">\n            <AppenderRef ref=\"rollingFile\" />\n            CONSOLE_X\n      </Root>\n   </Loggers>\n</Configuration>\n";
    private Logger logger = LoggerMain.getLogger("RTLogger");
    private static volatile RTLogger staticInstance = null;
    private static String lfDirectory = "logs/";
    private static String lfPrefix = "PREFIX";
    private static final String CONSOLE_TAG = "CONSOLE_X";
    private static final String CONSOLE_OFF = "<!--<AppenderRef ref=\"Console\" />-->";
    private static final String CONSOLE_ON = "<AppenderRef ref=\"Console\" />";
    private static int lfMaxFiles = 10;
    private static int lfMaxFileSizeMb = 10;
    private static int lfLevel = 1;
    private static int tempStoredLevel = 1;
    private static boolean consoleEnabled;
    private static Pattern patternSize;

    private RTLogger() {
    }

    public RTLogger(Class clazz) {
        this.logger = LoggerMain.getLogger(clazz);
    }

    public static void lockLogs() {
        tempStoredLevel = lfLevel;
        RTLogger.setLevel(0);
    }

    public static void unLockLogs() {
        lfLevel = tempStoredLevel;
    }

    public static int getMaxFileCount() {
        return lfMaxFiles;
    }

    public static long getMaxSizeMB() {
        return lfMaxFileSizeMb;
    }

    public static long getMaxSize() {
        return (long)lfMaxFileSizeMb * 0x100000L;
    }

    public static void flush() {
    }

    public static long parseMaxSize(String size) {
        long di;
        long maxSize = 0xA00000L;
        Matcher m = patternSize.matcher(size = size.toLowerCase());
        if (m.matches()) {
            String digits = m.group(1);
            di = 0L;
            try {
                di = Long.parseLong(digits);
            }
            catch (Throwable e) {
                throw new RuntimeException("invalid logfile size input string: " + size);
            }
        } else {
            throw new RuntimeException("invalid logfile size input string: " + size);
        }
        String suffix = m.group(2).toLowerCase();
        long mult = 1L;
        mult = suffix.equalsIgnoreCase("kb") ? 1024L : (suffix.equalsIgnoreCase("mb") || suffix.equalsIgnoreCase("m") ? 0x100000L : (suffix.equalsIgnoreCase("gb") ? 0x40000000L : 0x100000L));
        maxSize = di * mult;
        return maxSize;
    }

    public static void setDir(String logFileDir, String prefix) {
        lfDirectory = RTLogger.normalizePath(logFileDir);
        lfPrefix = prefix.endsWith("_") ? prefix.substring(0, prefix.length() - 1) : prefix;
    }

    public static void setLevel(int level) {
        lfLevel = level;
    }

    public static int getCurrentLevel() {
        return lfLevel;
    }

    public static void setMaxCount(int maxLogFilesCount) {
        lfMaxFiles = maxLogFilesCount;
    }

    public static void setMaxSize(long maxSizeInBytes) {
        lfMaxFileSizeMb = (int)(maxSizeInBytes / 0x100000L);
    }

    public static void storeConfig() {
        try {
            File log4jfile = new File(LOG4J2_CONFIG_FILE);
            String lfDirectoryForReplaceAll = lfDirectory.replace("\\", "\\\\").replace("$", "\\$");
            String configOnFly = LOG4J2_XML.replace("logs/", lfDirectoryForReplaceAll).replace("PREFIX", lfPrefix).replace(CONSOLE_TAG, consoleEnabled ? CONSOLE_ON : CONSOLE_OFF).replace("<Root level=\"INFO\">", "<Root level=\"" + RTLogger.getLevel4J() + "\">").replace("100 MB", lfMaxFileSizeMb + " MB").replace("15", "" + lfMaxFiles);
            FileUtils.writeFile(log4jfile, configOnFly);
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            System.out.println("Error processing xml4j config");
            e.printStackTrace();
        }
    }

    private static String getLevel4J() {
        switch (lfLevel) {
            case 0: {
                return "OFF";
            }
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "WARN";
            }
            case 3: {
                return "WARN";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "DEBUG";
            }
            case 6: {
                return "TRACE";
            }
        }
        return "ALL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Logger getStaticLogger() {
        if (staticInstance != null) return staticInstance;
        Class<RTLogger> clazz = RTLogger.class;
        synchronized (RTLogger.class) {
            if (staticInstance != null) return staticInstance;
            staticInstance = new RTLogger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return staticInstance;
        }
    }

    public static void print(int level, String msg) {
        MDC.put("lvl", "<" + level + ">");
        switch (level) {
            case 0: {
                break;
            }
            case 1: {
                if (level > lfLevel) break;
                RTLogger.getStaticLogger().error(msg);
                break;
            }
            case 2: 
            case 3: {
                if (level > lfLevel) break;
                RTLogger.getStaticLogger().warn(msg);
                break;
            }
            case 4: {
                if (level > lfLevel) break;
                RTLogger.getStaticLogger().info(msg);
                break;
            }
            case 5: {
                if (level > lfLevel) break;
                RTLogger.getStaticLogger().debug(msg);
                break;
            }
            default: {
                if (level > lfLevel) break;
                RTLogger.getStaticLogger().trace(msg);
            }
        }
    }

    public static void print(int level, StringBuilder msg) {
        RTLogger.print(level, msg.toString());
    }

    public static void print(int level, StringBuffer msg) {
        RTLogger.print(level, msg.toString());
    }

    public static void print(int level, String msg, Throwable e) {
        MDC.put("lvl", "<" + level + ">");
        switch (level) {
            case 0: {
                break;
            }
            case 1: {
                if (level > lfLevel) break;
                RTLogger.getStaticLogger().error(msg, e);
                break;
            }
            case 2: 
            case 3: {
                if (level > lfLevel) break;
                RTLogger.getStaticLogger().warn(msg, e);
                break;
            }
            case 4: {
                if (level > lfLevel) break;
                RTLogger.getStaticLogger().info(msg, e);
                break;
            }
            case 5: {
                if (level > lfLevel) break;
                RTLogger.getStaticLogger().debug(msg, e);
                break;
            }
            default: {
                if (level > lfLevel) break;
                RTLogger.getStaticLogger().trace(msg, e);
            }
        }
    }

    public static void print(int level, String msg, Object ... arguments) {
        RTLogger.print(level, String.format(msg, arguments));
    }

    public static String normalizePath(String logFileDir) {
        if (logFileDir == null || ((String)logFileDir).length() == 0) {
            return null;
        }
        logFileDir = FileUtils.resolveEnvVars((String)logFileDir);
        logFileDir = File.separator.equals("/") ? ((String)logFileDir).replace("\\", File.separator) : ((String)logFileDir).replace("/", File.separator);
        if (!((String)logFileDir).endsWith(File.separator)) {
            logFileDir = (String)logFileDir + File.separator;
        }
        return logFileDir;
    }

    public static boolean isConsoleEnabled() {
        return consoleEnabled;
    }

    public static void setConsoleEnabled(boolean consoleEnabled) {
        RTLogger.consoleEnabled = consoleEnabled;
    }

    public static String getCurrentFileName() {
        return lfPrefix + ".log";
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String s) {
        this.logger.trace(s);
    }

    @Override
    public void trace(String s, Object o) {
        this.logger.trace(s, o);
    }

    @Override
    public void trace(String s, Object o, Object o1) {
        this.logger.trace(s, o, o1);
    }

    @Override
    public void trace(String s, Object ... objects) {
        this.logger.trace(s, objects);
    }

    @Override
    public void trace(String s, Throwable throwable) {
        this.logger.trace(s, throwable);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    @Override
    public void trace(Marker marker, String s) {
        this.logger.trace(marker, s);
    }

    @Override
    public void trace(Marker marker, String s, Object o) {
        this.logger.trace(marker, s, o);
    }

    @Override
    public void trace(Marker marker, String s, Object o, Object o1) {
        this.logger.trace(marker, s, o, o);
    }

    @Override
    public void trace(Marker marker, String s, Object ... objects) {
        this.logger.trace(marker, s, objects);
    }

    @Override
    public void trace(Marker marker, String s, Throwable throwable) {
        this.logger.trace(marker, s, throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String s) {
        this.logger.debug(s);
    }

    @Override
    public void debug(String s, Object o) {
        this.logger.debug(s, o);
    }

    @Override
    public void debug(String s, Object o, Object o1) {
        this.logger.debug(s, o, o1);
    }

    @Override
    public void debug(String s, Object ... objects) {
        this.logger.debug(s, objects);
    }

    @Override
    public void debug(String s, Throwable throwable) {
        this.logger.debug(s, throwable);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    @Override
    public void debug(Marker marker, String s) {
        this.logger.debug(marker, s);
    }

    @Override
    public void debug(Marker marker, String s, Object o) {
        this.logger.debug(marker, s, o);
    }

    @Override
    public void debug(Marker marker, String s, Object o, Object o1) {
        this.logger.debug(marker, s, o, o1);
    }

    @Override
    public void debug(Marker marker, String s, Object ... objects) {
        this.logger.debug(marker, s, objects);
    }

    @Override
    public void debug(Marker marker, String s, Throwable throwable) {
        this.logger.debug(marker, s, throwable);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String s) {
        this.logger.info(s);
    }

    @Override
    public void info(String s, Object o) {
        this.logger.info(s, o);
    }

    @Override
    public void info(String s, Object o, Object o1) {
        this.logger.info(s, o, o1);
    }

    @Override
    public void info(String s, Object ... objects) {
        this.logger.info(s, objects);
    }

    @Override
    public void info(String s, Throwable throwable) {
        this.logger.info(s, throwable);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    @Override
    public void info(Marker marker, String s) {
        this.logger.info(marker, s);
    }

    @Override
    public void info(Marker marker, String s, Object o) {
        this.logger.info(marker, s, o);
    }

    @Override
    public void info(Marker marker, String s, Object o, Object o1) {
        this.logger.info(marker, s, o, o1);
    }

    @Override
    public void info(Marker marker, String s, Object ... objects) {
        this.logger.info(marker, s, objects);
    }

    @Override
    public void info(Marker marker, String s, Throwable throwable) {
        this.logger.info(marker, s, throwable);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String s) {
        this.logger.warn(s);
    }

    @Override
    public void warn(String s, Object o) {
        this.logger.warn(s, o);
    }

    @Override
    public void warn(String s, Object ... objects) {
        this.logger.warn(s, objects);
    }

    @Override
    public void warn(String s, Object o, Object o1) {
        this.logger.warn(s, o, o1);
    }

    @Override
    public void warn(String s, Throwable throwable) {
        this.logger.warn(s, throwable);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    @Override
    public void warn(Marker marker, String s) {
        this.logger.warn(marker, s);
    }

    @Override
    public void warn(Marker marker, String s, Object o) {
        this.logger.warn(marker, s, o);
    }

    @Override
    public void warn(Marker marker, String s, Object o, Object o1) {
        this.logger.warn(marker, s, o, o1);
    }

    @Override
    public void warn(Marker marker, String s, Object ... objects) {
        this.logger.warn(marker, s, objects);
    }

    @Override
    public void warn(Marker marker, String s, Throwable throwable) {
        this.logger.warn(marker, s, throwable);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String s) {
        this.logger.error(s);
    }

    @Override
    public void error(String s, Object o) {
        this.logger.error(s, o);
    }

    @Override
    public void error(String s, Object o, Object o1) {
        this.logger.error(s, o, o1);
    }

    @Override
    public void error(String s, Object ... objects) {
        this.logger.error(s, objects);
    }

    @Override
    public void error(String s, Throwable throwable) {
        this.logger.error(s, throwable);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    @Override
    public void error(Marker marker, String s) {
        this.logger.error(marker, s);
    }

    @Override
    public void error(Marker marker, String s, Object o) {
        this.logger.error(marker, s, o);
    }

    @Override
    public void error(Marker marker, String s, Object o, Object o1) {
        this.logger.error(marker, s, o, o1);
    }

    @Override
    public void error(Marker marker, String s, Object ... objects) {
        this.logger.error(marker, s, objects);
    }

    @Override
    public void error(Marker marker, String s, Throwable throwable) {
        this.logger.error(marker, s, throwable);
    }

    static {
        if (System.getProperty("log4j.configurationFile") == null) {
            System.setProperty("log4j.configurationFile", LOG4J2_CONFIG_FILE);
        }
        consoleEnabled = false;
        patternSize = Pattern.compile("\\s*(\\d+)\\s*(\\w*)\\s*");
    }
}

