/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa;

import com.blixx.log.RTLogger;
import com.blixx.sa.IHostnameResolver;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.utils.StrUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HostnameResolver
implements IHostnameResolver {
    public final Path hostsPath;
    public TreeMap<String, String> m_map = new TreeMap();
    public ReentrantReadWriteLock m_lock = new ReentrantReadWriteLock();
    public boolean isLowercase;

    public HostnameResolver(Path hostsPath, boolean lowercase) {
        this.hostsPath = hostsPath;
        this.isLowercase = lowercase;
        this.readHosts();
    }

    @Override
    public void reload() {
        this.m_lock.writeLock().lock();
        try {
            this.m_map.clear();
            this.readHosts();
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNameForAlias(String host, String agentID) {
        if (host == null) {
            return host;
        }
        if (this.isLowercase) {
            host = host.toLowerCase();
        }
        String res = host;
        this.m_lock.readLock().lock();
        try {
            if (agentID == null) {
                String hostOnlyRes = this.m_map.get(host);
                if (hostOnlyRes != null) {
                    res = hostOnlyRes;
                }
            } else {
                String res2 = this.m_map.get(agentID + "|" + host);
                if (res2 != null) {
                    res = res2;
                } else {
                    res2 = this.m_map.get(host);
                    if (res2 != null) {
                        res = res2;
                    }
                }
            }
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return res;
    }

    private void readHosts() {
        if (this.hostsPath != null && Files.exists(this.hostsPath, new LinkOption[0])) {
            if (this.hostsPath.toFile().canRead()) {
                try (FileReader fr = new FileReader(this.hostsPath.toFile());
                     BufferedReader br = new BufferedReader(fr);){
                    String line = null;
                    int count = 1;
                    StrUtils strUtils = new StrUtils();
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).length() > 0 && line.charAt(0) == '#') continue;
                        try {
                            line = line.replace('\t', ' ');
                            String[] aliases = strUtils.processQuoted(line);
                            if (aliases.length > 1) {
                                String majorName = strUtils.removeQuotes(aliases[0]);
                                if (this.isLowercase) {
                                    majorName = majorName.toLowerCase();
                                }
                                for (int i = 1; i < aliases.length; ++i) {
                                    String hostAlias = strUtils.removeQuotes(aliases[i]);
                                    if (this.isLowercase) {
                                        hostAlias = hostAlias.toLowerCase();
                                    }
                                    this.m_map.put(hostAlias, majorName);
                                }
                            }
                        }
                        catch (Throwable e) {
                            RTLogger.print(1, String.valueOf(this.hostsPath) + " line# " + count + " failed to process.");
                        }
                        ++count;
                    }
                    RTLogger.print(1, String.valueOf(this.hostsPath) + " processed lines: " + count);
                }
                catch (Throwable e) {
                    RTLogger.print(1, "srv/etc/hosts. Reading error", e);
                }
            } else {
                RTLogger.print(1, String.valueOf(this.hostsPath) + " file unreadable. Please check permissions");
            }
        } else {
            RTLogger.print(1, String.valueOf(this.hostsPath) + " file not found");
        }
    }

    @Override
    public String getFileContent() throws IOException {
        this.m_lock.writeLock().lock();
        try {
            String string = this.hostsPath == null ? null : FileUtils.readFile(this.hostsPath.toFile());
            return string;
        }
        catch (Exception e) {
            RTLogger.print(3, "Error reading srv/etc/hosts file", e);
            String string = null;
            return string;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }
}

